@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.MonitoredSubscriptionArgs.builder
import com.pulumi.azurenative.datadog.kotlin.enums.Status
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * The list of subscriptions and it's monitoring status by current Datadog monitor.
 * @property error The reason of not monitoring the subscription.
 * @property status The state of monitoring.
 * @property subscriptionId The subscriptionId to be monitored.
 * @property tagRules Definition of the properties for a TagRules resource.
 */
public data class MonitoredSubscriptionArgs(
    public val error: Output<String>? = null,
    public val status: Output<Either<String, Status>>? = null,
    public val subscriptionId: Output<String>? = null,
    public val tagRules: Output<MonitoringTagRulesPropertiesArgs>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.MonitoredSubscriptionArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.MonitoredSubscriptionArgs =
        com.pulumi.azurenative.datadog.inputs.MonitoredSubscriptionArgs.builder()
            .error(error?.applyValue({ args0 -> args0 }))
            .status(
                status?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .subscriptionId(subscriptionId?.applyValue({ args0 -> args0 }))
            .tagRules(tagRules?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MonitoredSubscriptionArgs].
 */
@PulumiTagMarker
public class MonitoredSubscriptionArgsBuilder internal constructor() {
    private var error: Output<String>? = null

    private var status: Output<Either<String, Status>>? = null

    private var subscriptionId: Output<String>? = null

    private var tagRules: Output<MonitoringTagRulesPropertiesArgs>? = null

    /**
     * @param value The reason of not monitoring the subscription.
     */
    @JvmName("jaajgiemojbpdkjf")
    public suspend fun error(`value`: Output<String>) {
        this.error = value
    }

    /**
     * @param value The state of monitoring.
     */
    @JvmName("qgvhmrgbbqadpnsc")
    public suspend fun status(`value`: Output<Either<String, Status>>) {
        this.status = value
    }

    /**
     * @param value The subscriptionId to be monitored.
     */
    @JvmName("nriyyetemxicnelo")
    public suspend fun subscriptionId(`value`: Output<String>) {
        this.subscriptionId = value
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("amjewuoigvybddyt")
    public suspend fun tagRules(`value`: Output<MonitoringTagRulesPropertiesArgs>) {
        this.tagRules = value
    }

    /**
     * @param value The reason of not monitoring the subscription.
     */
    @JvmName("rtsubiyurluukcjs")
    public suspend fun error(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.error = mapped
    }

    /**
     * @param value The state of monitoring.
     */
    @JvmName("ftpoehxxjqdtkqom")
    public suspend fun status(`value`: Either<String, Status>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The state of monitoring.
     */
    @JvmName("sclupbqflmnuipcy")
    public fun status(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The state of monitoring.
     */
    @JvmName("gdcqggjgwuclqout")
    public fun status(`value`: Status) {
        val toBeMapped = Either.ofRight<String, Status>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.status = mapped
    }

    /**
     * @param value The subscriptionId to be monitored.
     */
    @JvmName("fwnomwxwwbtkqvsm")
    public suspend fun subscriptionId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subscriptionId = mapped
    }

    /**
     * @param value Definition of the properties for a TagRules resource.
     */
    @JvmName("odcndwmjknfypurs")
    public suspend fun tagRules(`value`: MonitoringTagRulesPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tagRules = mapped
    }

    /**
     * @param argument Definition of the properties for a TagRules resource.
     */
    @JvmName("hralapbjfaeyqxyv")
    public suspend
    fun tagRules(argument: suspend MonitoringTagRulesPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = MonitoringTagRulesPropertiesArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.tagRules = mapped
    }

    internal fun build(): MonitoredSubscriptionArgs = MonitoredSubscriptionArgs(
        error = error,
        status = status,
        subscriptionId = subscriptionId,
        tagRules = tagRules,
    )
}
