@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.SubscriptionListArgs.builder
import com.pulumi.azurenative.datadog.kotlin.enums.Operation
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * The request to update subscriptions needed to be monitored by the Datadog monitor resource.
 * @property monitoredSubscriptionList List of subscriptions and the state of the monitoring.
 * @property operation The operation for the patch on the resource.
 */
public data class SubscriptionListArgs(
    public val monitoredSubscriptionList: Output<List<MonitoredSubscriptionArgs>>? = null,
    public val operation: Output<Either<String, Operation>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.SubscriptionListArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.SubscriptionListArgs =
        com.pulumi.azurenative.datadog.inputs.SubscriptionListArgs.builder()
            .monitoredSubscriptionList(
                monitoredSubscriptionList?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .operation(
                operation?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            ).build()
}

/**
 * Builder for [SubscriptionListArgs].
 */
@PulumiTagMarker
public class SubscriptionListArgsBuilder internal constructor() {
    private var monitoredSubscriptionList: Output<List<MonitoredSubscriptionArgs>>? = null

    private var operation: Output<Either<String, Operation>>? = null

    /**
     * @param value List of subscriptions and the state of the monitoring.
     */
    @JvmName("bpeurwbctohawepw")
    public suspend fun monitoredSubscriptionList(`value`: Output<List<MonitoredSubscriptionArgs>>) {
        this.monitoredSubscriptionList = value
    }

    @JvmName("npjavwbsaycgbtew")
    public suspend fun monitoredSubscriptionList(vararg values: Output<MonitoredSubscriptionArgs>) {
        this.monitoredSubscriptionList = Output.all(values.asList())
    }

    /**
     * @param values List of subscriptions and the state of the monitoring.
     */
    @JvmName("rxaguqgtwgmlghck")
    public suspend fun monitoredSubscriptionList(values: List<Output<MonitoredSubscriptionArgs>>) {
        this.monitoredSubscriptionList = Output.all(values)
    }

    /**
     * @param value The operation for the patch on the resource.
     */
    @JvmName("jfcurrodqpiasalo")
    public suspend fun operation(`value`: Output<Either<String, Operation>>) {
        this.operation = value
    }

    /**
     * @param value List of subscriptions and the state of the monitoring.
     */
    @JvmName("iyqtwaolivukvsbt")
    public suspend fun monitoredSubscriptionList(`value`: List<MonitoredSubscriptionArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.monitoredSubscriptionList = mapped
    }

    /**
     * @param argument List of subscriptions and the state of the monitoring.
     */
    @JvmName("efbaounjibisrqcq")
    public suspend
    fun monitoredSubscriptionList(argument: List<suspend MonitoredSubscriptionArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MonitoredSubscriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monitoredSubscriptionList = mapped
    }

    /**
     * @param argument List of subscriptions and the state of the monitoring.
     */
    @JvmName("owcsktfokuqdmjlj")
    public suspend fun monitoredSubscriptionList(
        vararg
        argument: suspend MonitoredSubscriptionArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MonitoredSubscriptionArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.monitoredSubscriptionList = mapped
    }

    /**
     * @param argument List of subscriptions and the state of the monitoring.
     */
    @JvmName("hfsprwsumbysnplc")
    public suspend
    fun monitoredSubscriptionList(argument: suspend MonitoredSubscriptionArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(MonitoredSubscriptionArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.monitoredSubscriptionList = mapped
    }

    /**
     * @param values List of subscriptions and the state of the monitoring.
     */
    @JvmName("jjpfrvkbivjjedhv")
    public suspend fun monitoredSubscriptionList(vararg values: MonitoredSubscriptionArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.monitoredSubscriptionList = mapped
    }

    /**
     * @param value The operation for the patch on the resource.
     */
    @JvmName("nnldmmtxptrbuxel")
    public suspend fun operation(`value`: Either<String, Operation>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value The operation for the patch on the resource.
     */
    @JvmName("uriqwcugxmrloobt")
    public fun operation(`value`: String) {
        val toBeMapped = Either.ofLeft<String, Operation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    /**
     * @param value The operation for the patch on the resource.
     */
    @JvmName("btmtkwjaicjfvnhe")
    public fun operation(`value`: Operation) {
        val toBeMapped = Either.ofRight<String, Operation>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.operation = mapped
    }

    internal fun build(): SubscriptionListArgs = SubscriptionListArgs(
        monitoredSubscriptionList = monitoredSubscriptionList,
        operation = operation,
    )
}
