@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.inputs

import com.pulumi.azurenative.datadog.inputs.UserInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * User info
 * @property emailAddress Email of the user used by Datadog for contacting them if needed
 * @property name Name of the user
 * @property phoneNumber Phone number of the user used by Datadog for contacting them if needed
 */
public data class UserInfoArgs(
    public val emailAddress: Output<String>? = null,
    public val name: Output<String>? = null,
    public val phoneNumber: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datadog.inputs.UserInfoArgs> {
    override fun toJava(): com.pulumi.azurenative.datadog.inputs.UserInfoArgs =
        com.pulumi.azurenative.datadog.inputs.UserInfoArgs.builder()
            .emailAddress(emailAddress?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .phoneNumber(phoneNumber?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserInfoArgs].
 */
@PulumiTagMarker
public class UserInfoArgsBuilder internal constructor() {
    private var emailAddress: Output<String>? = null

    private var name: Output<String>? = null

    private var phoneNumber: Output<String>? = null

    /**
     * @param value Email of the user used by Datadog for contacting them if needed
     */
    @JvmName("gvttrxcujwmchmqh")
    public suspend fun emailAddress(`value`: Output<String>) {
        this.emailAddress = value
    }

    /**
     * @param value Name of the user
     */
    @JvmName("ckipfqvqucvxgxqb")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Phone number of the user used by Datadog for contacting them if needed
     */
    @JvmName("cpmeutvvwmwhfflu")
    public suspend fun phoneNumber(`value`: Output<String>) {
        this.phoneNumber = value
    }

    /**
     * @param value Email of the user used by Datadog for contacting them if needed
     */
    @JvmName("jicliwmxbramvgif")
    public suspend fun emailAddress(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.emailAddress = mapped
    }

    /**
     * @param value Name of the user
     */
    @JvmName("xdiygjbfwmskmvwl")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Phone number of the user used by Datadog for contacting them if needed
     */
    @JvmName("kolaflqmbtosmroq")
    public suspend fun phoneNumber(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.phoneNumber = mapped
    }

    internal fun build(): UserInfoArgs = UserInfoArgs(
        emailAddress = emailAddress,
        name = name,
        phoneNumber = phoneNumber,
    )
}
