@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datadog.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * The request to update subscriptions needed to be monitored by the Datadog monitor resource.
 * @property id The id of the monitored subscription resource.
 * @property name Name of the monitored subscription resource.
 * @property properties The request to update subscriptions needed to be monitored by the Datadog monitor resource.
 * @property type The type of the monitored subscription resource.
 */
public data class GetMonitoredSubscriptionResult(
    public val id: String,
    public val name: String,
    public val properties: SubscriptionListResponse,
    public val type: String,
) {
    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datadog.outputs.GetMonitoredSubscriptionResult):
            GetMonitoredSubscriptionResult = GetMonitoredSubscriptionResult(
            id = javaType.id(),
            name = javaType.name(),
            properties = javaType.properties().let({ args0 ->
                com.pulumi.azurenative.datadog.kotlin.outputs.SubscriptionListResponse.Companion.toKotlin(args0)
            }),
            type = javaType.type(),
        )
    }
}
