@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getChangeDataCapturePlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getCredentialOperationPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getDataFlowPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getDatasetPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getExposureControlFeatureValueByFactoryPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getExposureControlFeatureValuePlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getFactoryDataPlaneAccessPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getFactoryGitHubAccessTokenPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getFactoryPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getGlobalParameterPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getIntegrationRuntimeConnectionInfoPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getIntegrationRuntimeObjectMetadatumPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getIntegrationRuntimePlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getIntegrationRuntimeStatusPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getLinkedServicePlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getManagedPrivateEndpointPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getPipelinePlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getPrivateEndpointConnectionPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getTriggerEventSubscriptionStatusPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.getTriggerPlain
import com.pulumi.azurenative.datafactory.DatafactoryFunctions.listIntegrationRuntimeAuthKeysPlain
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetChangeDataCapturePlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetChangeDataCapturePlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetCredentialOperationPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetCredentialOperationPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetDataFlowPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetDataFlowPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetDatasetPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetDatasetPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetExposureControlFeatureValueByFactoryPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetExposureControlFeatureValueByFactoryPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetExposureControlFeatureValuePlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetExposureControlFeatureValuePlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetFactoryDataPlaneAccessPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetFactoryDataPlaneAccessPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetFactoryGitHubAccessTokenPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetFactoryGitHubAccessTokenPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetFactoryPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetFactoryPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetGlobalParameterPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetGlobalParameterPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimeConnectionInfoPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimeConnectionInfoPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimePlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimePlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimeStatusPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetIntegrationRuntimeStatusPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetLinkedServicePlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetLinkedServicePlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetManagedPrivateEndpointPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetManagedPrivateEndpointPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetPipelinePlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetPipelinePlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetPrivateEndpointConnectionPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetPrivateEndpointConnectionPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetTriggerEventSubscriptionStatusPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetTriggerEventSubscriptionStatusPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetTriggerPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.GetTriggerPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.inputs.GitHubClientSecret
import com.pulumi.azurenative.datafactory.kotlin.inputs.ListIntegrationRuntimeAuthKeysPlainArgs
import com.pulumi.azurenative.datafactory.kotlin.inputs.ListIntegrationRuntimeAuthKeysPlainArgsBuilder
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetChangeDataCaptureResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetCredentialOperationResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetDataFlowResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetDatasetResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetExposureControlFeatureValueByFactoryResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetExposureControlFeatureValueResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetFactoryDataPlaneAccessResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetFactoryGitHubAccessTokenResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetFactoryResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetGlobalParameterResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeConnectionInfoResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeObjectMetadatumResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeStatusResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetLinkedServiceResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetManagedPrivateEndpointResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetPipelineResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetPrivateEndpointConnectionResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetTriggerEventSubscriptionStatusResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetTriggerResult
import com.pulumi.azurenative.datafactory.kotlin.outputs.ListIntegrationRuntimeAuthKeysResult
import kotlinx.coroutines.future.await
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetChangeDataCaptureResult.Companion.toKotlin as getChangeDataCaptureResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetCredentialOperationResult.Companion.toKotlin as getCredentialOperationResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetDataFlowResult.Companion.toKotlin as getDataFlowResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetDatasetResult.Companion.toKotlin as getDatasetResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetExposureControlFeatureValueByFactoryResult.Companion.toKotlin as getExposureControlFeatureValueByFactoryResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetExposureControlFeatureValueResult.Companion.toKotlin as getExposureControlFeatureValueResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetFactoryDataPlaneAccessResult.Companion.toKotlin as getFactoryDataPlaneAccessResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetFactoryGitHubAccessTokenResult.Companion.toKotlin as getFactoryGitHubAccessTokenResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetFactoryResult.Companion.toKotlin as getFactoryResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetGlobalParameterResult.Companion.toKotlin as getGlobalParameterResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeConnectionInfoResult.Companion.toKotlin as getIntegrationRuntimeConnectionInfoResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeObjectMetadatumResult.Companion.toKotlin as getIntegrationRuntimeObjectMetadatumResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeResult.Companion.toKotlin as getIntegrationRuntimeResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetIntegrationRuntimeStatusResult.Companion.toKotlin as getIntegrationRuntimeStatusResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetLinkedServiceResult.Companion.toKotlin as getLinkedServiceResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetManagedPrivateEndpointResult.Companion.toKotlin as getManagedPrivateEndpointResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetPipelineResult.Companion.toKotlin as getPipelineResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetPrivateEndpointConnectionResult.Companion.toKotlin as getPrivateEndpointConnectionResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetTriggerEventSubscriptionStatusResult.Companion.toKotlin as getTriggerEventSubscriptionStatusResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.GetTriggerResult.Companion.toKotlin as getTriggerResultToKotlin
import com.pulumi.azurenative.datafactory.kotlin.outputs.ListIntegrationRuntimeAuthKeysResult.Companion.toKotlin as listIntegrationRuntimeAuthKeysResultToKotlin

public object DatafactoryFunctions {
    /**
     * Gets a change data capture.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Change data capture resource type.
     */
    public suspend fun getChangeDataCapture(argument: GetChangeDataCapturePlainArgs):
        GetChangeDataCaptureResult =
        getChangeDataCaptureResultToKotlin(getChangeDataCapturePlain(argument.toJava()).await())

    /**
     * @see [getChangeDataCapture].
     * @param changeDataCaptureName The change data capture name.
     * @param factoryName The factory name.
     * @param resourceGroupName The resource group name.
     * @return Change data capture resource type.
     */
    public suspend fun getChangeDataCapture(
        changeDataCaptureName: String,
        factoryName: String,
        resourceGroupName: String,
    ): GetChangeDataCaptureResult {
        val argument = GetChangeDataCapturePlainArgs(
            changeDataCaptureName = changeDataCaptureName,
            factoryName = factoryName,
            resourceGroupName = resourceGroupName,
        )
        return getChangeDataCaptureResultToKotlin(getChangeDataCapturePlain(argument.toJava()).await())
    }

    /**
     * @see [getChangeDataCapture].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetChangeDataCapturePlainArgs].
     * @return Change data capture resource type.
     */
    public suspend
    fun getChangeDataCapture(argument: suspend GetChangeDataCapturePlainArgsBuilder.() -> Unit):
        GetChangeDataCaptureResult {
        val builder = GetChangeDataCapturePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getChangeDataCaptureResultToKotlin(getChangeDataCapturePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a credential.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Credential resource type.
     */
    public suspend fun getCredentialOperation(argument: GetCredentialOperationPlainArgs):
        GetCredentialOperationResult =
        getCredentialOperationResultToKotlin(getCredentialOperationPlain(argument.toJava()).await())

    /**
     * @see [getCredentialOperation].
     * @param credentialName Credential name
     * @param factoryName The factory name.
     * @param resourceGroupName The resource group name.
     * @return Credential resource type.
     */
    public suspend fun getCredentialOperation(
        credentialName: String,
        factoryName: String,
        resourceGroupName: String,
    ): GetCredentialOperationResult {
        val argument = GetCredentialOperationPlainArgs(
            credentialName = credentialName,
            factoryName = factoryName,
            resourceGroupName = resourceGroupName,
        )
        return getCredentialOperationResultToKotlin(getCredentialOperationPlain(argument.toJava()).await())
    }

    /**
     * @see [getCredentialOperation].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetCredentialOperationPlainArgs].
     * @return Credential resource type.
     */
    public suspend
    fun getCredentialOperation(argument: suspend GetCredentialOperationPlainArgsBuilder.() -> Unit):
        GetCredentialOperationResult {
        val builder = GetCredentialOperationPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getCredentialOperationResultToKotlin(getCredentialOperationPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a data flow.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Data flow resource type.
     */
    public suspend fun getDataFlow(argument: GetDataFlowPlainArgs): GetDataFlowResult =
        getDataFlowResultToKotlin(getDataFlowPlain(argument.toJava()).await())

    /**
     * @see [getDataFlow].
     * @param dataFlowName The data flow name.
     * @param factoryName The factory name.
     * @param resourceGroupName The resource group name.
     * @return Data flow resource type.
     */
    public suspend fun getDataFlow(
        dataFlowName: String,
        factoryName: String,
        resourceGroupName: String,
    ): GetDataFlowResult {
        val argument = GetDataFlowPlainArgs(
            dataFlowName = dataFlowName,
            factoryName = factoryName,
            resourceGroupName = resourceGroupName,
        )
        return getDataFlowResultToKotlin(getDataFlowPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataFlow].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetDataFlowPlainArgs].
     * @return Data flow resource type.
     */
    public suspend fun getDataFlow(argument: suspend GetDataFlowPlainArgsBuilder.() -> Unit):
        GetDataFlowResult {
        val builder = GetDataFlowPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDataFlowResultToKotlin(getDataFlowPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a dataset.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Dataset resource type.
     */
    public suspend fun getDataset(argument: GetDatasetPlainArgs): GetDatasetResult =
        getDatasetResultToKotlin(getDatasetPlain(argument.toJava()).await())

    /**
     * @see [getDataset].
     * @param datasetName The dataset name.
     * @param factoryName The factory name.
     * @param resourceGroupName The resource group name.
     * @return Dataset resource type.
     */
    public suspend fun getDataset(
        datasetName: String,
        factoryName: String,
        resourceGroupName: String,
    ): GetDatasetResult {
        val argument = GetDatasetPlainArgs(
            datasetName = datasetName,
            factoryName = factoryName,
            resourceGroupName = resourceGroupName,
        )
        return getDatasetResultToKotlin(getDatasetPlain(argument.toJava()).await())
    }

    /**
     * @see [getDataset].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetDatasetPlainArgs].
     * @return Dataset resource type.
     */
    public suspend fun getDataset(argument: suspend GetDatasetPlainArgsBuilder.() -> Unit):
        GetDatasetResult {
        val builder = GetDatasetPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getDatasetResultToKotlin(getDatasetPlain(builtArgument.toJava()).await())
    }

    /**
     * Get exposure control feature for specific location.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return The exposure control response.
     */
    public suspend
    fun getExposureControlFeatureValue(argument: GetExposureControlFeatureValuePlainArgs):
        GetExposureControlFeatureValueResult =
        getExposureControlFeatureValueResultToKotlin(getExposureControlFeatureValuePlain(argument.toJava()).await())

    /**
     * @see [getExposureControlFeatureValue].
     * @param featureName The feature name.
     * @param featureType The feature type.
     * @param locationId The location identifier.
     * @return The exposure control response.
     */
    public suspend fun getExposureControlFeatureValue(
        featureName: String? = null,
        featureType: String? = null,
        locationId: String,
    ): GetExposureControlFeatureValueResult {
        val argument = GetExposureControlFeatureValuePlainArgs(
            featureName = featureName,
            featureType = featureType,
            locationId = locationId,
        )
        return getExposureControlFeatureValueResultToKotlin(getExposureControlFeatureValuePlain(argument.toJava()).await())
    }

    /**
     * @see [getExposureControlFeatureValue].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetExposureControlFeatureValuePlainArgs].
     * @return The exposure control response.
     */
    public suspend
    fun getExposureControlFeatureValue(argument: suspend GetExposureControlFeatureValuePlainArgsBuilder.() -> Unit):
        GetExposureControlFeatureValueResult {
        val builder = GetExposureControlFeatureValuePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExposureControlFeatureValueResultToKotlin(getExposureControlFeatureValuePlain(builtArgument.toJava()).await())
    }

    /**
     * Get exposure control feature for specific factory.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return The exposure control response.
     */
    public suspend
    fun getExposureControlFeatureValueByFactory(argument: GetExposureControlFeatureValueByFactoryPlainArgs):
        GetExposureControlFeatureValueByFactoryResult =
        getExposureControlFeatureValueByFactoryResultToKotlin(getExposureControlFeatureValueByFactoryPlain(argument.toJava()).await())

    /**
     * @see [getExposureControlFeatureValueByFactory].
     * @param factoryName The factory name.
     * @param featureName The feature name.
     * @param featureType The feature type.
     * @param resourceGroupName The resource group name.
     * @return The exposure control response.
     */
    public suspend fun getExposureControlFeatureValueByFactory(
        factoryName: String,
        featureName: String? = null,
        featureType: String? = null,
        resourceGroupName: String,
    ): GetExposureControlFeatureValueByFactoryResult {
        val argument = GetExposureControlFeatureValueByFactoryPlainArgs(
            factoryName = factoryName,
            featureName = featureName,
            featureType = featureType,
            resourceGroupName = resourceGroupName,
        )
        return getExposureControlFeatureValueByFactoryResultToKotlin(getExposureControlFeatureValueByFactoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getExposureControlFeatureValueByFactory].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetExposureControlFeatureValueByFactoryPlainArgs].
     * @return The exposure control response.
     */
    public suspend
    fun getExposureControlFeatureValueByFactory(argument: suspend GetExposureControlFeatureValueByFactoryPlainArgsBuilder.() -> Unit):
        GetExposureControlFeatureValueByFactoryResult {
        val builder = GetExposureControlFeatureValueByFactoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getExposureControlFeatureValueByFactoryResultToKotlin(getExposureControlFeatureValueByFactoryPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a factory.
     * Azure REST API version: 2018-06-01.
     * Other available API versions: 2017-09-01-preview.
     * @param argument null
     * @return Factory resource type.
     */
    public suspend fun getFactory(argument: GetFactoryPlainArgs): GetFactoryResult =
        getFactoryResultToKotlin(getFactoryPlain(argument.toJava()).await())

    /**
     * @see [getFactory].
     * @param factoryName The factory name.
     * @param resourceGroupName The resource group name.
     * @return Factory resource type.
     */
    public suspend fun getFactory(factoryName: String, resourceGroupName: String): GetFactoryResult {
        val argument = GetFactoryPlainArgs(
            factoryName = factoryName,
            resourceGroupName = resourceGroupName,
        )
        return getFactoryResultToKotlin(getFactoryPlain(argument.toJava()).await())
    }

    /**
     * @see [getFactory].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetFactoryPlainArgs].
     * @return Factory resource type.
     */
    public suspend fun getFactory(argument: suspend GetFactoryPlainArgsBuilder.() -> Unit):
        GetFactoryResult {
        val builder = GetFactoryPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFactoryResultToKotlin(getFactoryPlain(builtArgument.toJava()).await())
    }

    /**
     * Get Data Plane access.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Get Data Plane read only token response definition.
     */
    public suspend fun getFactoryDataPlaneAccess(argument: GetFactoryDataPlaneAccessPlainArgs):
        GetFactoryDataPlaneAccessResult =
        getFactoryDataPlaneAccessResultToKotlin(getFactoryDataPlaneAccessPlain(argument.toJava()).await())

    /**
     * @see [getFactoryDataPlaneAccess].
     * @param accessResourcePath The resource path to get access relative to factory. Currently only empty string is supported which corresponds to the factory resource.
     * @param expireTime Expiration time for the token. Maximum duration for the token is eight hours and by default the token will expire in eight hours.
     * @param factoryName The factory name.
     * @param permissions The string with permissions for Data Plane access. Currently only 'r' is supported which grants read only access.
     * @param profileName The name of the profile. Currently only the default is supported. The default value is DefaultProfile.
     * @param resourceGroupName The resource group name.
     * @param startTime Start time for the token. If not specified the current time will be used.
     * @return Get Data Plane read only token response definition.
     */
    public suspend fun getFactoryDataPlaneAccess(
        accessResourcePath: String? = null,
        expireTime: String? = null,
        factoryName: String,
        permissions: String? = null,
        profileName: String? = null,
        resourceGroupName: String,
        startTime: String? = null,
    ): GetFactoryDataPlaneAccessResult {
        val argument = GetFactoryDataPlaneAccessPlainArgs(
            accessResourcePath = accessResourcePath,
            expireTime = expireTime,
            factoryName = factoryName,
            permissions = permissions,
            profileName = profileName,
            resourceGroupName = resourceGroupName,
            startTime = startTime,
        )
        return getFactoryDataPlaneAccessResultToKotlin(getFactoryDataPlaneAccessPlain(argument.toJava()).await())
    }

    /**
     * @see [getFactoryDataPlaneAccess].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetFactoryDataPlaneAccessPlainArgs].
     * @return Get Data Plane read only token response definition.
     */
    public suspend
    fun getFactoryDataPlaneAccess(argument: suspend GetFactoryDataPlaneAccessPlainArgsBuilder.() -> Unit):
        GetFactoryDataPlaneAccessResult {
        val builder = GetFactoryDataPlaneAccessPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFactoryDataPlaneAccessResultToKotlin(getFactoryDataPlaneAccessPlain(builtArgument.toJava()).await())
    }

    /**
     * Get GitHub Access Token.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Get GitHub access token response definition.
     */
    public suspend fun getFactoryGitHubAccessToken(argument: GetFactoryGitHubAccessTokenPlainArgs):
        GetFactoryGitHubAccessTokenResult =
        getFactoryGitHubAccessTokenResultToKotlin(getFactoryGitHubAccessTokenPlain(argument.toJava()).await())

    /**
     * @see [getFactoryGitHubAccessToken].
     * @param factoryName The factory name.
     * @param gitHubAccessCode GitHub access code.
     * @param gitHubAccessTokenBaseUrl GitHub access token base URL.
     * @param gitHubClientId GitHub application client ID.
     * @param gitHubClientSecret GitHub bring your own app client secret information.
     * @param resourceGroupName The resource group name.
     * @return Get GitHub access token response definition.
     */
    public suspend fun getFactoryGitHubAccessToken(
        factoryName: String,
        gitHubAccessCode: String,
        gitHubAccessTokenBaseUrl: String,
        gitHubClientId: String? = null,
        gitHubClientSecret: GitHubClientSecret? = null,
        resourceGroupName: String,
    ): GetFactoryGitHubAccessTokenResult {
        val argument = GetFactoryGitHubAccessTokenPlainArgs(
            factoryName = factoryName,
            gitHubAccessCode = gitHubAccessCode,
            gitHubAccessTokenBaseUrl = gitHubAccessTokenBaseUrl,
            gitHubClientId = gitHubClientId,
            gitHubClientSecret = gitHubClientSecret,
            resourceGroupName = resourceGroupName,
        )
        return getFactoryGitHubAccessTokenResultToKotlin(getFactoryGitHubAccessTokenPlain(argument.toJava()).await())
    }

    /**
     * @see [getFactoryGitHubAccessToken].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetFactoryGitHubAccessTokenPlainArgs].
     * @return Get GitHub access token response definition.
     */
    public suspend
    fun getFactoryGitHubAccessToken(argument: suspend GetFactoryGitHubAccessTokenPlainArgsBuilder.() -> Unit):
        GetFactoryGitHubAccessTokenResult {
        val builder = GetFactoryGitHubAccessTokenPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getFactoryGitHubAccessTokenResultToKotlin(getFactoryGitHubAccessTokenPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a Global parameter
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Global parameters resource type.
     */
    public suspend fun getGlobalParameter(argument: GetGlobalParameterPlainArgs):
        GetGlobalParameterResult =
        getGlobalParameterResultToKotlin(getGlobalParameterPlain(argument.toJava()).await())

    /**
     * @see [getGlobalParameter].
     * @param factoryName The factory name.
     * @param globalParameterName The global parameter name.
     * @param resourceGroupName The resource group name.
     * @return Global parameters resource type.
     */
    public suspend fun getGlobalParameter(
        factoryName: String,
        globalParameterName: String,
        resourceGroupName: String,
    ): GetGlobalParameterResult {
        val argument = GetGlobalParameterPlainArgs(
            factoryName = factoryName,
            globalParameterName = globalParameterName,
            resourceGroupName = resourceGroupName,
        )
        return getGlobalParameterResultToKotlin(getGlobalParameterPlain(argument.toJava()).await())
    }

    /**
     * @see [getGlobalParameter].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetGlobalParameterPlainArgs].
     * @return Global parameters resource type.
     */
    public suspend
    fun getGlobalParameter(argument: suspend GetGlobalParameterPlainArgsBuilder.() -> Unit):
        GetGlobalParameterResult {
        val builder = GetGlobalParameterPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getGlobalParameterResultToKotlin(getGlobalParameterPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets an integration runtime.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Integration runtime resource type.
     */
    public suspend fun getIntegrationRuntime(argument: GetIntegrationRuntimePlainArgs):
        GetIntegrationRuntimeResult =
        getIntegrationRuntimeResultToKotlin(getIntegrationRuntimePlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntime].
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param resourceGroupName The resource group name.
     * @return Integration runtime resource type.
     */
    public suspend fun getIntegrationRuntime(
        factoryName: String,
        integrationRuntimeName: String,
        resourceGroupName: String,
    ): GetIntegrationRuntimeResult {
        val argument = GetIntegrationRuntimePlainArgs(
            factoryName = factoryName,
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationRuntimeResultToKotlin(getIntegrationRuntimePlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntime].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimePlainArgs].
     * @return Integration runtime resource type.
     */
    public suspend
    fun getIntegrationRuntime(argument: suspend GetIntegrationRuntimePlainArgsBuilder.() -> Unit):
        GetIntegrationRuntimeResult {
        val builder = GetIntegrationRuntimePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeResultToKotlin(getIntegrationRuntimePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets the on-premises integration runtime connection information for encrypting the on-premises data source credentials.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Connection information for encrypting the on-premises data source credentials.
     */
    public suspend
    fun getIntegrationRuntimeConnectionInfo(argument: GetIntegrationRuntimeConnectionInfoPlainArgs):
        GetIntegrationRuntimeConnectionInfoResult =
        getIntegrationRuntimeConnectionInfoResultToKotlin(getIntegrationRuntimeConnectionInfoPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntimeConnectionInfo].
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param resourceGroupName The resource group name.
     * @return Connection information for encrypting the on-premises data source credentials.
     */
    public suspend fun getIntegrationRuntimeConnectionInfo(
        factoryName: String,
        integrationRuntimeName: String,
        resourceGroupName: String,
    ): GetIntegrationRuntimeConnectionInfoResult {
        val argument = GetIntegrationRuntimeConnectionInfoPlainArgs(
            factoryName = factoryName,
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationRuntimeConnectionInfoResultToKotlin(getIntegrationRuntimeConnectionInfoPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntimeConnectionInfo].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimeConnectionInfoPlainArgs].
     * @return Connection information for encrypting the on-premises data source credentials.
     */
    public suspend
    fun getIntegrationRuntimeConnectionInfo(argument: suspend GetIntegrationRuntimeConnectionInfoPlainArgsBuilder.() -> Unit):
        GetIntegrationRuntimeConnectionInfoResult {
        val builder = GetIntegrationRuntimeConnectionInfoPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeConnectionInfoResultToKotlin(getIntegrationRuntimeConnectionInfoPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a SSIS integration runtime object metadata by specified path. The return is pageable metadata list.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return A list of SSIS object metadata.
     */
    public suspend
    fun getIntegrationRuntimeObjectMetadatum(argument: GetIntegrationRuntimeObjectMetadatumPlainArgs):
        GetIntegrationRuntimeObjectMetadatumResult =
        getIntegrationRuntimeObjectMetadatumResultToKotlin(getIntegrationRuntimeObjectMetadatumPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntimeObjectMetadatum].
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param metadataPath Metadata path.
     * @param resourceGroupName The resource group name.
     * @return A list of SSIS object metadata.
     */
    public suspend fun getIntegrationRuntimeObjectMetadatum(
        factoryName: String,
        integrationRuntimeName: String,
        metadataPath: String? = null,
        resourceGroupName: String,
    ): GetIntegrationRuntimeObjectMetadatumResult {
        val argument = GetIntegrationRuntimeObjectMetadatumPlainArgs(
            factoryName = factoryName,
            integrationRuntimeName = integrationRuntimeName,
            metadataPath = metadataPath,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationRuntimeObjectMetadatumResultToKotlin(getIntegrationRuntimeObjectMetadatumPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntimeObjectMetadatum].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimeObjectMetadatumPlainArgs].
     * @return A list of SSIS object metadata.
     */
    public suspend
    fun getIntegrationRuntimeObjectMetadatum(argument: suspend GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder.() -> Unit):
        GetIntegrationRuntimeObjectMetadatumResult {
        val builder = GetIntegrationRuntimeObjectMetadatumPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeObjectMetadatumResultToKotlin(getIntegrationRuntimeObjectMetadatumPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets detailed status information for an integration runtime.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Integration runtime status response.
     */
    public suspend fun getIntegrationRuntimeStatus(argument: GetIntegrationRuntimeStatusPlainArgs):
        GetIntegrationRuntimeStatusResult =
        getIntegrationRuntimeStatusResultToKotlin(getIntegrationRuntimeStatusPlain(argument.toJava()).await())

    /**
     * @see [getIntegrationRuntimeStatus].
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param resourceGroupName The resource group name.
     * @return Integration runtime status response.
     */
    public suspend fun getIntegrationRuntimeStatus(
        factoryName: String,
        integrationRuntimeName: String,
        resourceGroupName: String,
    ): GetIntegrationRuntimeStatusResult {
        val argument = GetIntegrationRuntimeStatusPlainArgs(
            factoryName = factoryName,
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
        )
        return getIntegrationRuntimeStatusResultToKotlin(getIntegrationRuntimeStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getIntegrationRuntimeStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetIntegrationRuntimeStatusPlainArgs].
     * @return Integration runtime status response.
     */
    public suspend
    fun getIntegrationRuntimeStatus(argument: suspend GetIntegrationRuntimeStatusPlainArgsBuilder.() -> Unit):
        GetIntegrationRuntimeStatusResult {
        val builder = GetIntegrationRuntimeStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getIntegrationRuntimeStatusResultToKotlin(getIntegrationRuntimeStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a linked service.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Linked service resource type.
     */
    public suspend fun getLinkedService(argument: GetLinkedServicePlainArgs): GetLinkedServiceResult =
        getLinkedServiceResultToKotlin(getLinkedServicePlain(argument.toJava()).await())

    /**
     * @see [getLinkedService].
     * @param factoryName The factory name.
     * @param linkedServiceName The linked service name.
     * @param resourceGroupName The resource group name.
     * @return Linked service resource type.
     */
    public suspend fun getLinkedService(
        factoryName: String,
        linkedServiceName: String,
        resourceGroupName: String,
    ): GetLinkedServiceResult {
        val argument = GetLinkedServicePlainArgs(
            factoryName = factoryName,
            linkedServiceName = linkedServiceName,
            resourceGroupName = resourceGroupName,
        )
        return getLinkedServiceResultToKotlin(getLinkedServicePlain(argument.toJava()).await())
    }

    /**
     * @see [getLinkedService].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetLinkedServicePlainArgs].
     * @return Linked service resource type.
     */
    public suspend
    fun getLinkedService(argument: suspend GetLinkedServicePlainArgsBuilder.() -> Unit):
        GetLinkedServiceResult {
        val builder = GetLinkedServicePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getLinkedServiceResultToKotlin(getLinkedServicePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a managed private endpoint.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Managed private endpoint resource type.
     */
    public suspend fun getManagedPrivateEndpoint(argument: GetManagedPrivateEndpointPlainArgs):
        GetManagedPrivateEndpointResult =
        getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(argument.toJava()).await())

    /**
     * @see [getManagedPrivateEndpoint].
     * @param factoryName The factory name.
     * @param managedPrivateEndpointName Managed private endpoint name
     * @param managedVirtualNetworkName Managed virtual network name
     * @param resourceGroupName The resource group name.
     * @return Managed private endpoint resource type.
     */
    public suspend fun getManagedPrivateEndpoint(
        factoryName: String,
        managedPrivateEndpointName: String,
        managedVirtualNetworkName: String,
        resourceGroupName: String,
    ): GetManagedPrivateEndpointResult {
        val argument = GetManagedPrivateEndpointPlainArgs(
            factoryName = factoryName,
            managedPrivateEndpointName = managedPrivateEndpointName,
            managedVirtualNetworkName = managedVirtualNetworkName,
            resourceGroupName = resourceGroupName,
        )
        return getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(argument.toJava()).await())
    }

    /**
     * @see [getManagedPrivateEndpoint].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetManagedPrivateEndpointPlainArgs].
     * @return Managed private endpoint resource type.
     */
    public suspend
    fun getManagedPrivateEndpoint(argument: suspend GetManagedPrivateEndpointPlainArgsBuilder.() -> Unit):
        GetManagedPrivateEndpointResult {
        val builder = GetManagedPrivateEndpointPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getManagedPrivateEndpointResultToKotlin(getManagedPrivateEndpointPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a pipeline.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Pipeline resource type.
     */
    public suspend fun getPipeline(argument: GetPipelinePlainArgs): GetPipelineResult =
        getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())

    /**
     * @see [getPipeline].
     * @param factoryName The factory name.
     * @param pipelineName The pipeline name.
     * @param resourceGroupName The resource group name.
     * @return Pipeline resource type.
     */
    public suspend fun getPipeline(
        factoryName: String,
        pipelineName: String,
        resourceGroupName: String,
    ): GetPipelineResult {
        val argument = GetPipelinePlainArgs(
            factoryName = factoryName,
            pipelineName = pipelineName,
            resourceGroupName = resourceGroupName,
        )
        return getPipelineResultToKotlin(getPipelinePlain(argument.toJava()).await())
    }

    /**
     * @see [getPipeline].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetPipelinePlainArgs].
     * @return Pipeline resource type.
     */
    public suspend fun getPipeline(argument: suspend GetPipelinePlainArgsBuilder.() -> Unit):
        GetPipelineResult {
        val builder = GetPipelinePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPipelineResultToKotlin(getPipelinePlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a private endpoint connection
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Private Endpoint Connection ARM resource.
     */
    public suspend fun getPrivateEndpointConnection(argument: GetPrivateEndpointConnectionPlainArgs):
        GetPrivateEndpointConnectionResult =
        getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())

    /**
     * @see [getPrivateEndpointConnection].
     * @param factoryName The factory name.
     * @param privateEndpointConnectionName The private endpoint connection name.
     * @param resourceGroupName The resource group name.
     * @return Private Endpoint Connection ARM resource.
     */
    public suspend fun getPrivateEndpointConnection(
        factoryName: String,
        privateEndpointConnectionName: String,
        resourceGroupName: String,
    ): GetPrivateEndpointConnectionResult {
        val argument = GetPrivateEndpointConnectionPlainArgs(
            factoryName = factoryName,
            privateEndpointConnectionName = privateEndpointConnectionName,
            resourceGroupName = resourceGroupName,
        )
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(argument.toJava()).await())
    }

    /**
     * @see [getPrivateEndpointConnection].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetPrivateEndpointConnectionPlainArgs].
     * @return Private Endpoint Connection ARM resource.
     */
    public suspend
    fun getPrivateEndpointConnection(argument: suspend GetPrivateEndpointConnectionPlainArgsBuilder.() -> Unit):
        GetPrivateEndpointConnectionResult {
        val builder = GetPrivateEndpointConnectionPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getPrivateEndpointConnectionResultToKotlin(getPrivateEndpointConnectionPlain(builtArgument.toJava()).await())
    }

    /**
     * Gets a trigger.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Trigger resource type.
     */
    public suspend fun getTrigger(argument: GetTriggerPlainArgs): GetTriggerResult =
        getTriggerResultToKotlin(getTriggerPlain(argument.toJava()).await())

    /**
     * @see [getTrigger].
     * @param factoryName The factory name.
     * @param resourceGroupName The resource group name.
     * @param triggerName The trigger name.
     * @return Trigger resource type.
     */
    public suspend fun getTrigger(
        factoryName: String,
        resourceGroupName: String,
        triggerName: String,
    ): GetTriggerResult {
        val argument = GetTriggerPlainArgs(
            factoryName = factoryName,
            resourceGroupName = resourceGroupName,
            triggerName = triggerName,
        )
        return getTriggerResultToKotlin(getTriggerPlain(argument.toJava()).await())
    }

    /**
     * @see [getTrigger].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetTriggerPlainArgs].
     * @return Trigger resource type.
     */
    public suspend fun getTrigger(argument: suspend GetTriggerPlainArgsBuilder.() -> Unit):
        GetTriggerResult {
        val builder = GetTriggerPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTriggerResultToKotlin(getTriggerPlain(builtArgument.toJava()).await())
    }

    /**
     * Get a trigger's event subscription status.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return Defines the response of a trigger subscription operation.
     */
    public suspend
    fun getTriggerEventSubscriptionStatus(argument: GetTriggerEventSubscriptionStatusPlainArgs):
        GetTriggerEventSubscriptionStatusResult =
        getTriggerEventSubscriptionStatusResultToKotlin(getTriggerEventSubscriptionStatusPlain(argument.toJava()).await())

    /**
     * @see [getTriggerEventSubscriptionStatus].
     * @param factoryName The factory name.
     * @param resourceGroupName The resource group name.
     * @param triggerName The trigger name.
     * @return Defines the response of a trigger subscription operation.
     */
    public suspend fun getTriggerEventSubscriptionStatus(
        factoryName: String,
        resourceGroupName: String,
        triggerName: String,
    ): GetTriggerEventSubscriptionStatusResult {
        val argument = GetTriggerEventSubscriptionStatusPlainArgs(
            factoryName = factoryName,
            resourceGroupName = resourceGroupName,
            triggerName = triggerName,
        )
        return getTriggerEventSubscriptionStatusResultToKotlin(getTriggerEventSubscriptionStatusPlain(argument.toJava()).await())
    }

    /**
     * @see [getTriggerEventSubscriptionStatus].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;GetTriggerEventSubscriptionStatusPlainArgs].
     * @return Defines the response of a trigger subscription operation.
     */
    public suspend
    fun getTriggerEventSubscriptionStatus(argument: suspend GetTriggerEventSubscriptionStatusPlainArgsBuilder.() -> Unit):
        GetTriggerEventSubscriptionStatusResult {
        val builder = GetTriggerEventSubscriptionStatusPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return getTriggerEventSubscriptionStatusResultToKotlin(getTriggerEventSubscriptionStatusPlain(builtArgument.toJava()).await())
    }

    /**
     * Retrieves the authentication keys for an integration runtime.
     * Azure REST API version: 2018-06-01.
     * @param argument null
     * @return The integration runtime authentication keys.
     */
    public suspend
    fun listIntegrationRuntimeAuthKeys(argument: ListIntegrationRuntimeAuthKeysPlainArgs):
        ListIntegrationRuntimeAuthKeysResult =
        listIntegrationRuntimeAuthKeysResultToKotlin(listIntegrationRuntimeAuthKeysPlain(argument.toJava()).await())

    /**
     * @see [listIntegrationRuntimeAuthKeys].
     * @param factoryName The factory name.
     * @param integrationRuntimeName The integration runtime name.
     * @param resourceGroupName The resource group name.
     * @return The integration runtime authentication keys.
     */
    public suspend fun listIntegrationRuntimeAuthKeys(
        factoryName: String,
        integrationRuntimeName: String,
        resourceGroupName: String,
    ): ListIntegrationRuntimeAuthKeysResult {
        val argument = ListIntegrationRuntimeAuthKeysPlainArgs(
            factoryName = factoryName,
            integrationRuntimeName = integrationRuntimeName,
            resourceGroupName = resourceGroupName,
        )
        return listIntegrationRuntimeAuthKeysResultToKotlin(listIntegrationRuntimeAuthKeysPlain(argument.toJava()).await())
    }

    /**
     * @see [listIntegrationRuntimeAuthKeys].
     * @param argument Builder for [com&#46;pulumi&#46;azurenative&#46;datafactory&#46;kotlin&#46;inputs&#46;ListIntegrationRuntimeAuthKeysPlainArgs].
     * @return The integration runtime authentication keys.
     */
    public suspend
    fun listIntegrationRuntimeAuthKeys(argument: suspend ListIntegrationRuntimeAuthKeysPlainArgsBuilder.() -> Unit):
        ListIntegrationRuntimeAuthKeysResult {
        val builder = ListIntegrationRuntimeAuthKeysPlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return listIntegrationRuntimeAuthKeysResultToKotlin(listIntegrationRuntimeAuthKeysPlain(builtArgument.toJava()).await())
    }
}
