@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Any
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Dataset].
 */
@PulumiTagMarker
public class DatasetResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DatasetArgs = DatasetArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DatasetArgsBuilder.() -> Unit) {
        val builder = DatasetArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Dataset {
        val builtJavaResource = com.pulumi.azurenative.datafactory.Dataset(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Dataset(builtJavaResource)
    }
}

/**
 * Dataset resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### Datasets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataset = new AzureNative.DataFactory.Dataset("dataset", new()
 *     {
 *         DatasetName = "exampleDataset",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureBlobDatasetArgs
 *         {
 *             FileName =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFileName" },
 *             },
 *             FolderPath =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFolderPath" },
 *             },
 *             Format = new AzureNative.DataFactory.Inputs.TextFormatArgs
 *             {
 *                 Type = "TextFormat",
 *             },
 *             LinkedServiceName = new AzureNative.DataFactory.Inputs.LinkedServiceReferenceArgs
 *             {
 *                 ReferenceName = "exampleLinkedService",
 *                 Type = AzureNative.DataFactory.Type.LinkedServiceReference,
 *             },
 *             Parameters =
 *             {
 *                 { "MyFileName", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *                 { "MyFolderPath", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *             },
 *             Type = "AzureBlob",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datafactory.NewDataset(ctx, "dataset", &datafactory.DatasetArgs{
 * DatasetName: pulumi.String("exampleDataset"),
 * FactoryName: pulumi.String("exampleFactoryName"),
 * Properties: datafactory.AzureBlobDataset{
 * FileName: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFileName",
 * },
 * FolderPath: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFolderPath",
 * },
 * Format: datafactory.TextFormat{
 * Type: "TextFormat",
 * },
 * LinkedServiceName: datafactory.LinkedServiceReference{
 * ReferenceName: "exampleLinkedService",
 * Type: datafactory.TypeLinkedServiceReference,
 * },
 * Parameters: interface{}{
 * MyFileName: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * MyFolderPath: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * },
 * Type: "AzureBlob",
 * },
 * ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Dataset;
 * import com.pulumi.azurenative.datafactory.DatasetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataset = new Dataset("dataset", DatasetArgs.builder()
 *             .datasetName("exampleDataset")
 *             .factoryName("exampleFactoryName")
 *             .properties(AzureBlobDatasetArgs.builder()
 *                 .fileName(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFileName")
 *                 ))
 *                 .folderPath(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFolderPath")
 *                 ))
 *                 .format(TextFormatArgs.builder()
 *                     .type("TextFormat")
 *                     .build())
 *                 .linkedServiceName(LinkedServiceReferenceArgs.builder()
 *                     .referenceName("exampleLinkedService")
 *                     .type("LinkedServiceReference")
 *                     .build())
 *                 .parameters(Map.ofEntries(
 *                     Map.entry("MyFileName", Map.of("type", "String")),
 *                     Map.entry("MyFolderPath", Map.of("type", "String"))
 *                 ))
 *                 .type("AzureBlob")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Datasets_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataset = new AzureNative.DataFactory.Dataset("dataset", new()
 *     {
 *         DatasetName = "exampleDataset",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureBlobDatasetArgs
 *         {
 *             Description = "Example description",
 *             FileName =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFileName" },
 *             },
 *             FolderPath =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFolderPath" },
 *             },
 *             Format = new AzureNative.DataFactory.Inputs.TextFormatArgs
 *             {
 *                 Type = "TextFormat",
 *             },
 *             LinkedServiceName = new AzureNative.DataFactory.Inputs.LinkedServiceReferenceArgs
 *             {
 *                 ReferenceName = "exampleLinkedService",
 *                 Type = AzureNative.DataFactory.Type.LinkedServiceReference,
 *             },
 *             Parameters =
 *             {
 *                 { "MyFileName", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *                 { "MyFolderPath", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *             },
 *             Type = "AzureBlob",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datafactory.NewDataset(ctx, "dataset", &datafactory.DatasetArgs{
 * DatasetName: pulumi.String("exampleDataset"),
 * FactoryName: pulumi.String("exampleFactoryName"),
 * Properties: datafactory.AzureBlobDataset{
 * Description: "Example description",
 * FileName: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFileName",
 * },
 * FolderPath: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFolderPath",
 * },
 * Format: datafactory.TextFormat{
 * Type: "TextFormat",
 * },
 * LinkedServiceName: datafactory.LinkedServiceReference{
 * ReferenceName: "exampleLinkedService",
 * Type: datafactory.TypeLinkedServiceReference,
 * },
 * Parameters: interface{}{
 * MyFileName: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * MyFolderPath: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * },
 * Type: "AzureBlob",
 * },
 * ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Dataset;
 * import com.pulumi.azurenative.datafactory.DatasetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataset = new Dataset("dataset", DatasetArgs.builder()
 *             .datasetName("exampleDataset")
 *             .factoryName("exampleFactoryName")
 *             .properties(AzureBlobDatasetArgs.builder()
 *                 .description("Example description")
 *                 .fileName(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFileName")
 *                 ))
 *                 .folderPath(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFolderPath")
 *                 ))
 *                 .format(TextFormatArgs.builder()
 *                     .type("TextFormat")
 *                     .build())
 *                 .linkedServiceName(LinkedServiceReferenceArgs.builder()
 *                     .referenceName("exampleLinkedService")
 *                     .type("LinkedServiceReference")
 *                     .build())
 *                 .parameters(Map.ofEntries(
 *                     Map.entry("MyFileName", Map.of("type", "String")),
 *                     Map.entry("MyFolderPath", Map.of("type", "String"))
 *                 ))
 *                 .type("AzureBlob")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:Dataset exampleDataset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/datasets/{datasetName}
 * ```
 */
public class Dataset internal constructor(
    override val javaResource: com.pulumi.azurenative.datafactory.Dataset,
) : KotlinCustomResource(javaResource, DatasetMapper) {
    /**
     * Etag identifies change in the resource.
     */
    public val etag: Output<String>
        get() = javaResource.etag().applyValue({ args0 -> args0 })

    /**
     * The resource name.
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * Dataset properties.
     */
    public val properties: Output<Any>
        get() = javaResource.properties().applyValue({ args0 -> args0 })

    /**
     * The resource type.
     */
    public val type: Output<String>
        get() = javaResource.type().applyValue({ args0 -> args0 })
}

public object DatasetMapper : ResourceMapper<Dataset> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.azurenative.datafactory.Dataset::class == javaResource::class

    override fun map(javaResource: Resource): Dataset = Dataset(
        javaResource as
            com.pulumi.azurenative.datafactory.Dataset,
    )
}

/**
 * @see [Dataset].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Dataset].
 */
public suspend fun dataset(name: String, block: suspend DatasetResourceBuilder.() -> Unit):
    Dataset {
    val builder = DatasetResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Dataset].
 * @param name The _unique_ name of the resulting resource.
 */
public fun dataset(name: String): Dataset {
    val builder = DatasetResourceBuilder()
    builder.name(name)
    return builder.build()
}
