@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.DatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Dataset resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### Datasets_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataset = new AzureNative.DataFactory.Dataset("dataset", new()
 *     {
 *         DatasetName = "exampleDataset",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureBlobDatasetArgs
 *         {
 *             FileName =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFileName" },
 *             },
 *             FolderPath =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFolderPath" },
 *             },
 *             Format = new AzureNative.DataFactory.Inputs.TextFormatArgs
 *             {
 *                 Type = "TextFormat",
 *             },
 *             LinkedServiceName = new AzureNative.DataFactory.Inputs.LinkedServiceReferenceArgs
 *             {
 *                 ReferenceName = "exampleLinkedService",
 *                 Type = AzureNative.DataFactory.Type.LinkedServiceReference,
 *             },
 *             Parameters =
 *             {
 *                 { "MyFileName", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *                 { "MyFolderPath", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *             },
 *             Type = "AzureBlob",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datafactory.NewDataset(ctx, "dataset", &datafactory.DatasetArgs{
 * DatasetName: pulumi.String("exampleDataset"),
 * FactoryName: pulumi.String("exampleFactoryName"),
 * Properties: datafactory.AzureBlobDataset{
 * FileName: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFileName",
 * },
 * FolderPath: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFolderPath",
 * },
 * Format: datafactory.TextFormat{
 * Type: "TextFormat",
 * },
 * LinkedServiceName: datafactory.LinkedServiceReference{
 * ReferenceName: "exampleLinkedService",
 * Type: datafactory.TypeLinkedServiceReference,
 * },
 * Parameters: interface{}{
 * MyFileName: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * MyFolderPath: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * },
 * Type: "AzureBlob",
 * },
 * ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Dataset;
 * import com.pulumi.azurenative.datafactory.DatasetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataset = new Dataset("dataset", DatasetArgs.builder()
 *             .datasetName("exampleDataset")
 *             .factoryName("exampleFactoryName")
 *             .properties(AzureBlobDatasetArgs.builder()
 *                 .fileName(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFileName")
 *                 ))
 *                 .folderPath(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFolderPath")
 *                 ))
 *                 .format(TextFormatArgs.builder()
 *                     .type("TextFormat")
 *                     .build())
 *                 .linkedServiceName(LinkedServiceReferenceArgs.builder()
 *                     .referenceName("exampleLinkedService")
 *                     .type("LinkedServiceReference")
 *                     .build())
 *                 .parameters(Map.ofEntries(
 *                     Map.entry("MyFileName", Map.of("type", "String")),
 *                     Map.entry("MyFolderPath", Map.of("type", "String"))
 *                 ))
 *                 .type("AzureBlob")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ### Datasets_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var dataset = new AzureNative.DataFactory.Dataset("dataset", new()
 *     {
 *         DatasetName = "exampleDataset",
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.AzureBlobDatasetArgs
 *         {
 *             Description = "Example description",
 *             FileName =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFileName" },
 *             },
 *             FolderPath =
 *             {
 *                 { "type", "Expression" },
 *                 { "value", "@dataset().MyFolderPath" },
 *             },
 *             Format = new AzureNative.DataFactory.Inputs.TextFormatArgs
 *             {
 *                 Type = "TextFormat",
 *             },
 *             LinkedServiceName = new AzureNative.DataFactory.Inputs.LinkedServiceReferenceArgs
 *             {
 *                 ReferenceName = "exampleLinkedService",
 *                 Type = AzureNative.DataFactory.Type.LinkedServiceReference,
 *             },
 *             Parameters =
 *             {
 *                 { "MyFileName", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *                 { "MyFolderPath", new AzureNative.DataFactory.Inputs.ParameterSpecificationArgs
 *                 {
 *                     Type = AzureNative.DataFactory.ParameterType.String,
 *                 } },
 *             },
 *             Type = "AzureBlob",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * pulumi.Run(func(ctx *pulumi.Context) error {
 * _, err := datafactory.NewDataset(ctx, "dataset", &datafactory.DatasetArgs{
 * DatasetName: pulumi.String("exampleDataset"),
 * FactoryName: pulumi.String("exampleFactoryName"),
 * Properties: datafactory.AzureBlobDataset{
 * Description: "Example description",
 * FileName: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFileName",
 * },
 * FolderPath: map[string]interface{}{
 * "type": "Expression",
 * "value": "@dataset().MyFolderPath",
 * },
 * Format: datafactory.TextFormat{
 * Type: "TextFormat",
 * },
 * LinkedServiceName: datafactory.LinkedServiceReference{
 * ReferenceName: "exampleLinkedService",
 * Type: datafactory.TypeLinkedServiceReference,
 * },
 * Parameters: interface{}{
 * MyFileName: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * MyFolderPath: datafactory.ParameterSpecification{
 * Type: datafactory.ParameterTypeString,
 * },
 * },
 * Type: "AzureBlob",
 * },
 * ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * })
 * if err != nil {
 * return err
 * }
 * return nil
 * })
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Dataset;
 * import com.pulumi.azurenative.datafactory.DatasetArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var dataset = new Dataset("dataset", DatasetArgs.builder()
 *             .datasetName("exampleDataset")
 *             .factoryName("exampleFactoryName")
 *             .properties(AzureBlobDatasetArgs.builder()
 *                 .description("Example description")
 *                 .fileName(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFileName")
 *                 ))
 *                 .folderPath(Map.ofEntries(
 *                     Map.entry("type", "Expression"),
 *                     Map.entry("value", "@dataset().MyFolderPath")
 *                 ))
 *                 .format(TextFormatArgs.builder()
 *                     .type("TextFormat")
 *                     .build())
 *                 .linkedServiceName(LinkedServiceReferenceArgs.builder()
 *                     .referenceName("exampleLinkedService")
 *                     .type("LinkedServiceReference")
 *                     .build())
 *                 .parameters(Map.ofEntries(
 *                     Map.entry("MyFileName", Map.of("type", "String")),
 *                     Map.entry("MyFolderPath", Map.of("type", "String"))
 *                 ))
 *                 .type("AzureBlob")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:Dataset exampleDataset /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/datasets/{datasetName}
 * ```
 * @property datasetName The dataset name.
 * @property factoryName The factory name.
 * @property properties Dataset properties.
 * @property resourceGroupName The resource group name.
 */
public data class DatasetArgs(
    public val datasetName: Output<String>? = null,
    public val factoryName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.DatasetArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.DatasetArgs =
        com.pulumi.azurenative.datafactory.DatasetArgs.builder()
            .datasetName(datasetName?.applyValue({ args0 -> args0 }))
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetArgs].
 */
@PulumiTagMarker
public class DatasetArgsBuilder internal constructor() {
    private var datasetName: Output<String>? = null

    private var factoryName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    /**
     * @param value The dataset name.
     */
    @JvmName("fksssqlaoleflhqd")
    public suspend fun datasetName(`value`: Output<String>) {
        this.datasetName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("ekfhgecquhexiqpu")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value Dataset properties.
     */
    @JvmName("esxdeejpgwptwlcp")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("wgqcopnjfwkdjilg")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The dataset name.
     */
    @JvmName("klcwipnfsambxpbo")
    public suspend fun datasetName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.datasetName = mapped
    }

    /**
     * @param value The factory name.
     */
    @JvmName("kkilesyqknccukwp")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value Dataset properties.
     */
    @JvmName("fqdnnufqqdqcgusf")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("cfukplcrdivwvpuf")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    internal fun build(): DatasetArgs = DatasetArgs(
        datasetName = datasetName,
        factoryName = factoryName,
        properties = properties,
        resourceGroupName = resourceGroupName,
    )
}
