@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin

import com.pulumi.azurenative.datafactory.TriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Trigger resource type.
 * Azure REST API version: 2018-06-01. Prior API version in Azure Native 1.x: 2018-06-01.
 * ## Example Usage
 * ### Triggers_Create
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trigger = new AzureNative.DataFactory.Trigger("trigger", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.ScheduleTriggerArgs
 *         {
 *             Pipelines = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.TriggerPipelineReferenceArgs
 *                 {
 *                     Parameters =
 *                     {
 *                         { "OutputBlobNameList", new[]
 *                         {
 *                             "exampleoutput.csv",
 *                         } },
 *                     },
 *                     PipelineReference = new AzureNative.DataFactory.Inputs.PipelineReferenceArgs
 *                     {
 *                         ReferenceName = "examplePipeline",
 *                         Type = "PipelineReference",
 *                     },
 *                 },
 *             },
 *             Recurrence = new AzureNative.DataFactory.Inputs.ScheduleTriggerRecurrenceArgs
 *             {
 *                 EndTime = "2018-06-16T00:55:13.8441801Z",
 *                 Frequency = AzureNative.DataFactory.RecurrenceFrequency.Minute,
 *                 Interval = 4,
 *                 StartTime = "2018-06-16T00:39:13.8441801Z",
 *                 TimeZone = "UTC",
 *             },
 *             Type = "ScheduleTrigger",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         TriggerName = "exampleTrigger",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewTrigger(ctx, "trigger", &datafactory.TriggerArgs{
 * 			FactoryName: pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.ScheduleTrigger{
 * 				Pipelines: []datafactory.TriggerPipelineReference{
 * 					{
 * 						Parameters: {
 * 							"OutputBlobNameList": []string{
 * 								"exampleoutput.csv",
 * 							},
 * 						},
 * 						PipelineReference: {
 * 							ReferenceName: "examplePipeline",
 * 							Type:          "PipelineReference",
 * 						},
 * 					},
 * 				},
 * 				Recurrence: datafactory.ScheduleTriggerRecurrence{
 * 					EndTime:   "2018-06-16T00:55:13.8441801Z",
 * 					Frequency: datafactory.RecurrenceFrequencyMinute,
 * 					Interval:  4,
 * 					StartTime: "2018-06-16T00:39:13.8441801Z",
 * 					TimeZone:  "UTC",
 * 				},
 * 				Type: "ScheduleTrigger",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			TriggerName:       pulumi.String("exampleTrigger"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Trigger;
 * import com.pulumi.azurenative.datafactory.TriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trigger = new Trigger("trigger", TriggerArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .properties(ScheduleTriggerArgs.builder()
 *                 .pipelines(TriggerPipelineReferenceArgs.builder()
 *                     .parameters(Map.of("OutputBlobNameList", "exampleoutput.csv"))
 *                     .pipelineReference(PipelineReferenceArgs.builder()
 *                         .referenceName("examplePipeline")
 *                         .type("PipelineReference")
 *                         .build())
 *                     .build())
 *                 .recurrence(ScheduleTriggerRecurrenceArgs.builder()
 *                     .endTime("2018-06-16T00:55:13.8441801Z")
 *                     .frequency("Minute")
 *                     .interval(4)
 *                     .startTime("2018-06-16T00:39:13.8441801Z")
 *                     .timeZone("UTC")
 *                     .build())
 *                 .type("ScheduleTrigger")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .triggerName("exampleTrigger")
 *             .build());
 *     }
 * }
 * ```
 * ### Triggers_Update
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using AzureNative = Pulumi.AzureNative;
 * return await Deployment.RunAsync(() =>
 * {
 *     var trigger = new AzureNative.DataFactory.Trigger("trigger", new()
 *     {
 *         FactoryName = "exampleFactoryName",
 *         Properties = new AzureNative.DataFactory.Inputs.ScheduleTriggerArgs
 *         {
 *             Description = "Example description",
 *             Pipelines = new[]
 *             {
 *                 new AzureNative.DataFactory.Inputs.TriggerPipelineReferenceArgs
 *                 {
 *                     Parameters =
 *                     {
 *                         { "OutputBlobNameList", new[]
 *                         {
 *                             "exampleoutput.csv",
 *                         } },
 *                     },
 *                     PipelineReference = new AzureNative.DataFactory.Inputs.PipelineReferenceArgs
 *                     {
 *                         ReferenceName = "examplePipeline",
 *                         Type = "PipelineReference",
 *                     },
 *                 },
 *             },
 *             Recurrence = new AzureNative.DataFactory.Inputs.ScheduleTriggerRecurrenceArgs
 *             {
 *                 EndTime = "2018-06-16T00:55:14.905167Z",
 *                 Frequency = AzureNative.DataFactory.RecurrenceFrequency.Minute,
 *                 Interval = 4,
 *                 StartTime = "2018-06-16T00:39:14.905167Z",
 *                 TimeZone = "UTC",
 *             },
 *             Type = "ScheduleTrigger",
 *         },
 *         ResourceGroupName = "exampleResourceGroup",
 *         TriggerName = "exampleTrigger",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-azure-native-sdk/datafactory/v2"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := datafactory.NewTrigger(ctx, "trigger", &datafactory.TriggerArgs{
 * 			FactoryName: pulumi.String("exampleFactoryName"),
 * 			Properties: datafactory.ScheduleTrigger{
 * 				Description: "Example description",
 * 				Pipelines: []datafactory.TriggerPipelineReference{
 * 					{
 * 						Parameters: {
 * 							"OutputBlobNameList": []string{
 * 								"exampleoutput.csv",
 * 							},
 * 						},
 * 						PipelineReference: {
 * 							ReferenceName: "examplePipeline",
 * 							Type:          "PipelineReference",
 * 						},
 * 					},
 * 				},
 * 				Recurrence: datafactory.ScheduleTriggerRecurrence{
 * 					EndTime:   "2018-06-16T00:55:14.905167Z",
 * 					Frequency: datafactory.RecurrenceFrequencyMinute,
 * 					Interval:  4,
 * 					StartTime: "2018-06-16T00:39:14.905167Z",
 * 					TimeZone:  "UTC",
 * 				},
 * 				Type: "ScheduleTrigger",
 * 			},
 * 			ResourceGroupName: pulumi.String("exampleResourceGroup"),
 * 			TriggerName:       pulumi.String("exampleTrigger"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.azurenative.datafactory.Trigger;
 * import com.pulumi.azurenative.datafactory.TriggerArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var trigger = new Trigger("trigger", TriggerArgs.builder()
 *             .factoryName("exampleFactoryName")
 *             .properties(ScheduleTriggerArgs.builder()
 *                 .description("Example description")
 *                 .pipelines(TriggerPipelineReferenceArgs.builder()
 *                     .parameters(Map.of("OutputBlobNameList", "exampleoutput.csv"))
 *                     .pipelineReference(PipelineReferenceArgs.builder()
 *                         .referenceName("examplePipeline")
 *                         .type("PipelineReference")
 *                         .build())
 *                     .build())
 *                 .recurrence(ScheduleTriggerRecurrenceArgs.builder()
 *                     .endTime("2018-06-16T00:55:14.905167Z")
 *                     .frequency("Minute")
 *                     .interval(4)
 *                     .startTime("2018-06-16T00:39:14.905167Z")
 *                     .timeZone("UTC")
 *                     .build())
 *                 .type("ScheduleTrigger")
 *                 .build())
 *             .resourceGroupName("exampleResourceGroup")
 *             .triggerName("exampleTrigger")
 *             .build());
 *     }
 * }
 * ```
 * ## Import
 * An existing resource can be imported using its type token, name, and identifier, e.g.
 * ```sh
 * $ pulumi import azure-native:datafactory:Trigger exampleTrigger /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.DataFactory/factories/{factoryName}/triggers/{triggerName}
 * ```
 * @property factoryName The factory name.
 * @property properties Properties of the trigger.
 * @property resourceGroupName The resource group name.
 * @property triggerName The trigger name.
 */
public data class TriggerArgs(
    public val factoryName: Output<String>? = null,
    public val properties: Output<Any>? = null,
    public val resourceGroupName: Output<String>? = null,
    public val triggerName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.TriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.TriggerArgs =
        com.pulumi.azurenative.datafactory.TriggerArgs.builder()
            .factoryName(factoryName?.applyValue({ args0 -> args0 }))
            .properties(properties?.applyValue({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName?.applyValue({ args0 -> args0 }))
            .triggerName(triggerName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [TriggerArgs].
 */
@PulumiTagMarker
public class TriggerArgsBuilder internal constructor() {
    private var factoryName: Output<String>? = null

    private var properties: Output<Any>? = null

    private var resourceGroupName: Output<String>? = null

    private var triggerName: Output<String>? = null

    /**
     * @param value The factory name.
     */
    @JvmName("yaaixhvxowiesbin")
    public suspend fun factoryName(`value`: Output<String>) {
        this.factoryName = value
    }

    /**
     * @param value Properties of the trigger.
     */
    @JvmName("dkbigtcwhgubsabl")
    public suspend fun properties(`value`: Output<Any>) {
        this.properties = value
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("qokggcoejylsxqxd")
    public suspend fun resourceGroupName(`value`: Output<String>) {
        this.resourceGroupName = value
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("oxnphyximaxubxgn")
    public suspend fun triggerName(`value`: Output<String>) {
        this.triggerName = value
    }

    /**
     * @param value The factory name.
     */
    @JvmName("vptryafojjcmjxpb")
    public suspend fun factoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.factoryName = mapped
    }

    /**
     * @param value Properties of the trigger.
     */
    @JvmName("yxxrpbxhabnfiqll")
    public suspend fun properties(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.properties = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("unieteccnrelwccj")
    public suspend fun resourceGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceGroupName = mapped
    }

    /**
     * @param value The trigger name.
     */
    @JvmName("rwmnittkqcykpbuj")
    public suspend fun triggerName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.triggerName = mapped
    }

    internal fun build(): TriggerArgs = TriggerArgs(
        factoryName = factoryName,
        properties = properties,
        resourceGroupName = resourceGroupName,
        triggerName = triggerName,
    )
}
