@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Compute type of the cluster which will execute data flow job.
 */
public enum class DataFlowComputeType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.DataFlowComputeType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.DataFlowComputeType> {
    General(com.pulumi.azurenative.datafactory.enums.DataFlowComputeType.General),
    MemoryOptimized(com.pulumi.azurenative.datafactory.enums.DataFlowComputeType.MemoryOptimized),
    ComputeOptimized(com.pulumi.azurenative.datafactory.enums.DataFlowComputeType.ComputeOptimized),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.DataFlowComputeType = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.DataFlowComputeType):
            DataFlowComputeType = DataFlowComputeType.values().first { it.javaValue == javaType }
    }
}
