@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
 */
public enum class GoogleAdWordsAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.GoogleAdWordsAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.GoogleAdWordsAuthenticationType> {
    ServiceAuthentication(com.pulumi.azurenative.datafactory.enums.GoogleAdWordsAuthenticationType.ServiceAuthentication),
    UserAuthentication(com.pulumi.azurenative.datafactory.enums.GoogleAdWordsAuthenticationType.UserAuthentication),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.GoogleAdWordsAuthenticationType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.GoogleAdWordsAuthenticationType):
            GoogleAdWordsAuthenticationType =
            GoogleAdWordsAuthenticationType.values().first { it.javaValue == javaType }
    }
}
