@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * The OAuth 2.0 authentication mechanism used for authentication. ServiceAuthentication can only be used on self-hosted IR.
 */
public enum class GoogleBigQueryAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.GoogleBigQueryAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.GoogleBigQueryAuthenticationType> {
    ServiceAuthentication(com.pulumi.azurenative.datafactory.enums.GoogleBigQueryAuthenticationType.ServiceAuthentication),
    UserAuthentication(com.pulumi.azurenative.datafactory.enums.GoogleBigQueryAuthenticationType.UserAuthentication),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.GoogleBigQueryAuthenticationType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.GoogleBigQueryAuthenticationType):
            GoogleBigQueryAuthenticationType =
            GoogleBigQueryAuthenticationType.values().first { it.javaValue == javaType }
    }
}
