@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of authentication used to connect to the OData service.
 */
public enum class ODataAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType> {
    Basic(com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType.Basic),
    Anonymous(com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType.Anonymous),
    Windows(com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType.Windows),
    AadServicePrincipal(com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType.AadServicePrincipal),
    ManagedServiceIdentity(com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType.ManagedServiceIdentity),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType =
        javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.ODataAuthenticationType):
            ODataAuthenticationType =
            ODataAuthenticationType.values().first { it.javaValue == javaType }
    }
}
