@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Type of authentication used to connect to the REST service.
 */
public enum class RestServiceAuthenticationType(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType> {
    Anonymous(com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType.Anonymous),
    Basic(com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType.Basic),
    AadServicePrincipal(com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType.AadServicePrincipal),
    ManagedServiceIdentity(com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType.ManagedServiceIdentity),
    OAuth2ClientCredential(com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType.OAuth2ClientCredential),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType =
        javaValue

    public companion object {
        public
        fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.RestServiceAuthenticationType):
            RestServiceAuthenticationType =
            RestServiceAuthenticationType.values().first { it.javaValue == javaType }
    }
}
