@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.enums

import com.pulumi.kotlin.ConvertibleToJava
import kotlin.Suppress

/**
 * Linked service reference type.
 */
public enum class Type(
    public val javaValue: com.pulumi.azurenative.datafactory.enums.Type,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.enums.Type> {
    LinkedServiceReference(com.pulumi.azurenative.datafactory.enums.Type.LinkedServiceReference),
    ;

    override fun toJava(): com.pulumi.azurenative.datafactory.enums.Type = javaValue

    public companion object {
        public fun toKotlin(javaType: com.pulumi.azurenative.datafactory.enums.Type): Type =
            Type.values().first { it.javaValue == javaType }
    }
}
