@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOracleTableDatasetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * The AmazonRdsForOracle database dataset.
 * @property annotations List of tags that can be used for describing the Dataset.
 * @property description Dataset description.
 * @property folder The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
 * @property linkedServiceName Linked service reference.
 * @property parameters Parameters for dataset.
 * @property schema Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
 * @property structure Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
 * @property table The table name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
 * @property type Type of dataset.
 * Expected value is 'AmazonRdsForOracleTable'.
 */
public data class AmazonRdsForOracleTableDatasetArgs(
    public val annotations: Output<List<Any>>? = null,
    public val description: Output<String>? = null,
    public val folder: Output<DatasetFolderArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val schema: Output<Any>? = null,
    public val structure: Output<Any>? = null,
    public val table: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOracleTableDatasetArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOracleTableDatasetArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonRdsForOracleTableDatasetArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .folder(folder?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .schema(schema?.applyValue({ args0 -> args0 }))
            .structure(structure?.applyValue({ args0 -> args0 }))
            .table(table?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonRdsForOracleTableDatasetArgs].
 */
@PulumiTagMarker
public class AmazonRdsForOracleTableDatasetArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var description: Output<String>? = null

    private var folder: Output<DatasetFolderArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var schema: Output<Any>? = null

    private var structure: Output<Any>? = null

    private var table: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("nquwavtiodwaamyo")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("hcdchvnbeaitlqri")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("nwxokxbjjmwslyat")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("bbrqctpkmjtlydgh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("obhadhipdwvrfevy")
    public suspend fun folder(`value`: Output<DatasetFolderArgs>) {
        this.folder = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("nrsolvxuiiwlnrcg")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("rydvyvlihtjbaxvs")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("gqptnoyujcwnrivh")
    public suspend fun schema(`value`: Output<Any>) {
        this.schema = value
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("dwxotskuynskglcc")
    public suspend fun structure(`value`: Output<Any>) {
        this.structure = value
    }

    /**
     * @param value The table name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
     */
    @JvmName("pqnqxayfgruwsbip")
    public suspend fun table(`value`: Output<Any>) {
        this.table = value
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'AmazonRdsForOracleTable'.
     */
    @JvmName("wuacxbnuojpptbuv")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the Dataset.
     */
    @JvmName("lyftvjihhforcvnw")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the Dataset.
     */
    @JvmName("cffrferabnnvkuaf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Dataset description.
     */
    @JvmName("ivlseflimvivlkph")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("tomykyxvueqftgxn")
    public suspend fun folder(`value`: DatasetFolderArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folder = mapped
    }

    /**
     * @param argument The folder that this Dataset is in. If not specified, Dataset will appear at the root level.
     */
    @JvmName("twlqkxmetwawgugp")
    public suspend fun folder(argument: suspend DatasetFolderArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetFolderArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.folder = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("jnsbkyuyktygalvr")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("citxibussdtspnyd")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Parameters for dataset.
     */
    @JvmName("miumflgbrgdcwlbs")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for dataset.
     */
    @JvmName("ashiksknwnfrnsjw")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for dataset.
     */
    @JvmName("nphibkotpdkphopf")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Columns that define the physical type schema of the dataset. Type: array (or Expression with resultType array), itemType: DatasetSchemaDataElement.
     */
    @JvmName("jakkynpqytdpmvym")
    public suspend fun schema(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.schema = mapped
    }

    /**
     * @param value Columns that define the structure of the dataset. Type: array (or Expression with resultType array), itemType: DatasetDataElement.
     */
    @JvmName("glpdfoppvyialhus")
    public suspend fun structure(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.structure = mapped
    }

    /**
     * @param value The table name of the AmazonRdsForOracle database. Type: string (or Expression with resultType string).
     */
    @JvmName("qjyrreckjydtoesx")
    public suspend fun table(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.table = mapped
    }

    /**
     * @param value Type of dataset.
     * Expected value is 'AmazonRdsForOracleTable'.
     */
    @JvmName("sangulnvltusxtjv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AmazonRdsForOracleTableDatasetArgs = AmazonRdsForOracleTableDatasetArgs(
        annotations = annotations,
        description = description,
        folder = folder,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        parameters = parameters,
        schema = schema,
        structure = structure,
        table = table,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
