@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonRedshiftSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity source for Amazon Redshift Source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property query Database query. Type: string (or Expression with resultType string).
 * @property queryTimeout Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property redshiftUnloadSettings The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'AmazonRedshiftSource'.
 */
public data class AmazonRedshiftSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val query: Output<Any>? = null,
    public val queryTimeout: Output<Any>? = null,
    public val redshiftUnloadSettings: Output<RedshiftUnloadSettingsArgs>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonRedshiftSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AmazonRedshiftSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonRedshiftSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .queryTimeout(queryTimeout?.applyValue({ args0 -> args0 }))
            .redshiftUnloadSettings(
                redshiftUnloadSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonRedshiftSourceArgs].
 */
@PulumiTagMarker
public class AmazonRedshiftSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var query: Output<Any>? = null

    private var queryTimeout: Output<Any>? = null

    private var redshiftUnloadSettings: Output<RedshiftUnloadSettingsArgs>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("rtmgrvwrbchhmsin")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("iutcbsvasrpjvycn")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("cldydkvrjfmtjiwt")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Database query. Type: string (or Expression with resultType string).
     */
    @JvmName("msrrnfhdigmnnhhc")
    public suspend fun query(`value`: Output<Any>) {
        this.query = value
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("cfmpnymretyepbqj")
    public suspend fun queryTimeout(`value`: Output<Any>) {
        this.queryTimeout = value
    }

    /**
     * @param value The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
     */
    @JvmName("wbjukmjvfsedabey")
    public suspend fun redshiftUnloadSettings(`value`: Output<RedshiftUnloadSettingsArgs>) {
        this.redshiftUnloadSettings = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("uinhqdbhjjnsixmx")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("lcjepiqcsoyklgot")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'AmazonRedshiftSource'.
     */
    @JvmName("ddlijgoofvynkwni")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("axpibeblpkkxwkeg")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("eeoreegbunwbcuqg")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("vnmteuswcovrxehq")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Database query. Type: string (or Expression with resultType string).
     */
    @JvmName("qdgkwvwwnoqusilx")
    public suspend fun query(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Query timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("aphoqkmplflblpvo")
    public suspend fun queryTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.queryTimeout = mapped
    }

    /**
     * @param value The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
     */
    @JvmName("nqiapcfxgleksadm")
    public suspend fun redshiftUnloadSettings(`value`: RedshiftUnloadSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redshiftUnloadSettings = mapped
    }

    /**
     * @param argument The Amazon S3 settings needed for the interim Amazon S3 when copying from Amazon Redshift with unload. With this, data from Amazon Redshift source will be unloaded into S3 first and then copied into the targeted sink from the interim S3.
     */
    @JvmName("gpchbpucuyaiylbh")
    public suspend
    fun redshiftUnloadSettings(argument: suspend RedshiftUnloadSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = RedshiftUnloadSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.redshiftUnloadSettings = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("cchehretjtgjcupo")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("gvaukscfiohqgxcp")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'AmazonRedshiftSource'.
     */
    @JvmName("kadmaiccnxggtgvg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AmazonRedshiftSourceArgs = AmazonRedshiftSourceArgs(
        additionalColumns = additionalColumns,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        query = query,
        queryTimeout = queryTimeout,
        redshiftUnloadSettings = redshiftUnloadSettings,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
