@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for Amazon S3 Compatible.
 * @property accessKeyId The access key identifier of the Amazon S3 Compatible Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property forcePathStyle If true, use S3 path-style access instead of virtual hosted-style access. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property parameters Parameters for linked service.
 * @property secretAccessKey The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
 * @property serviceUrl This value specifies the endpoint to access with the Amazon S3 Compatible Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AmazonS3Compatible'.
 */
public data class AmazonS3CompatibleLinkedServiceArgs(
    public val accessKeyId: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val forcePathStyle: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val secretAccessKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val serviceUrl: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLinkedServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonS3CompatibleLinkedServiceArgs.builder()
            .accessKeyId(accessKeyId?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .forcePathStyle(forcePathStyle?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .secretAccessKey(
                secretAccessKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .serviceUrl(serviceUrl?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonS3CompatibleLinkedServiceArgs].
 */
@PulumiTagMarker
public class AmazonS3CompatibleLinkedServiceArgsBuilder internal constructor() {
    private var accessKeyId: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var forcePathStyle: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var secretAccessKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var serviceUrl: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The access key identifier of the Amazon S3 Compatible Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
     */
    @JvmName("etlvgcaxafgntrjx")
    public suspend fun accessKeyId(`value`: Output<Any>) {
        this.accessKeyId = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vpmcmvlfwhdokshw")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("swsynwnmjftwjaku")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("duqsovwltglspeoh")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("nsimuhbuynwmbupl")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ewqlhdcognqkebrh")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("dkaewrhnlysjacls")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value If true, use S3 path-style access instead of virtual hosted-style access. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("veixnsbflovcelut")
    public suspend fun forcePathStyle(`value`: Output<Any>) {
        this.forcePathStyle = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("galcsvnrttxeymnh")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
     */
    @JvmName("bnwsmxqgtrekbqfg")
    public suspend
    fun secretAccessKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.secretAccessKey = value
    }

    /**
     * @param value This value specifies the endpoint to access with the Amazon S3 Compatible Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
     */
    @JvmName("tivysnvumtctuoig")
    public suspend fun serviceUrl(`value`: Output<Any>) {
        this.serviceUrl = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonS3Compatible'.
     */
    @JvmName("ahhxeuhhbvlkoexl")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The access key identifier of the Amazon S3 Compatible Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
     */
    @JvmName("hudwtiyrixccoydn")
    public suspend fun accessKeyId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKeyId = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("miiyclanrlpibgxw")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("rxuisrqchgdcunog")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("loigvsqiovfnvbwy")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("rpsrskdjwafqislh")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("gutstgiffwgdscdf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("aylextvsinxmqrsg")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value If true, use S3 path-style access instead of virtual hosted-style access. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("uacagehhmpsrlqcq")
    public suspend fun forcePathStyle(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.forcePathStyle = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("bqmquaxfcygugvih")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("wovthqvdygcgjbfg")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("tlwaquiigfatnqss")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
     */
    @JvmName("nwdhvpdjbsfxtmed")
    public suspend
    fun secretAccessKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretAccessKey = mapped
    }

    /**
     * @param value The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
     */
    @JvmName("jlugblevlapoicsf")
    public fun secretAccessKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretAccessKey = mapped
    }

    /**
     * @param value The secret access key of the Amazon S3 Compatible Identity and Access Management (IAM) user.
     */
    @JvmName("yjctdpmeubfmhlqf")
    public fun secretAccessKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretAccessKey = mapped
    }

    /**
     * @param value This value specifies the endpoint to access with the Amazon S3 Compatible Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
     */
    @JvmName("qxerrgfcrmvjhbnb")
    public suspend fun serviceUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUrl = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonS3Compatible'.
     */
    @JvmName("hskvgrmhhnbtwavv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AmazonS3CompatibleLinkedServiceArgs = AmazonS3CompatibleLinkedServiceArgs(
        accessKeyId = accessKeyId,
        annotations = annotations,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        forcePathStyle = forcePathStyle,
        parameters = parameters,
        secretAccessKey = secretAccessKey,
        serviceUrl = serviceUrl,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
