@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AmazonS3LinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Linked service for Amazon S3.
 * @property accessKeyId The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property secretAccessKey The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
 * @property serviceUrl This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
 * @property sessionToken The session token for the S3 temporary security credential.
 * @property type Type of linked service.
 * Expected value is 'AmazonS3'.
 */
public data class AmazonS3LinkedServiceArgs(
    public val accessKeyId: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val secretAccessKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val serviceUrl: Output<Any>? = null,
    public val sessionToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AmazonS3LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AmazonS3LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AmazonS3LinkedServiceArgs.builder()
            .accessKeyId(accessKeyId?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .secretAccessKey(
                secretAccessKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .serviceUrl(serviceUrl?.applyValue({ args0 -> args0 }))
            .sessionToken(
                sessionToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AmazonS3LinkedServiceArgs].
 */
@PulumiTagMarker
public class AmazonS3LinkedServiceArgsBuilder internal constructor() {
    private var accessKeyId: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var secretAccessKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var serviceUrl: Output<Any>? = null

    private var sessionToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
     */
    @JvmName("ukfuqqiyncbmntwv")
    public suspend fun accessKeyId(`value`: Output<Any>) {
        this.accessKeyId = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("ynjilxbxvfmkhcag")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ilbapxifxkwkdajj")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("sibmscmvdtktwupn")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
     */
    @JvmName("rgccgpmtwocwklkb")
    public suspend fun authenticationType(`value`: Output<Any>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("eugirgohtgdwirja")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ljhkradhckajeudx")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("orivhykknqowwfjy")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("smjueygtlqclgura")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
     */
    @JvmName("neucsypxjfcmleuq")
    public suspend
    fun secretAccessKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.secretAccessKey = value
    }

    /**
     * @param value This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
     */
    @JvmName("pjlnesxiyqvyyans")
    public suspend fun serviceUrl(`value`: Output<Any>) {
        this.serviceUrl = value
    }

    /**
     * @param value The session token for the S3 temporary security credential.
     */
    @JvmName("umlvxhnckhygkllh")
    public suspend
    fun sessionToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.sessionToken = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonS3'.
     */
    @JvmName("utmxewltiydnpgfb")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The access key identifier of the Amazon S3 Identity and Access Management (IAM) user. Type: string (or Expression with resultType string).
     */
    @JvmName("fpliyhjmncgsemlj")
    public suspend fun accessKeyId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKeyId = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("iismfyotjqlpwyim")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("vqgaupdvxrkuudyl")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The authentication type of S3. Allowed value: AccessKey (default) or TemporarySecurityCredentials. Type: string (or Expression with resultType string).
     */
    @JvmName("ieiylqgssyixrhec")
    public suspend fun authenticationType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("pxcvnwdswixodqqi")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("tviyroruuugarqhg")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("gnqsjvqoxgkwnlmh")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("bmpcbysmiewdkebg")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("blobolnumilrykwr")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("vwgghqedhiqfjdvm")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("ikcndhumimcdtago")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
     */
    @JvmName("fivjrkklyxelkhtn")
    public suspend
    fun secretAccessKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretAccessKey = mapped
    }

    /**
     * @param value The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
     */
    @JvmName("kfabsqwssgqhcapg")
    public fun secretAccessKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretAccessKey = mapped
    }

    /**
     * @param value The secret access key of the Amazon S3 Identity and Access Management (IAM) user.
     */
    @JvmName("mtgnuerycssxsaic")
    public fun secretAccessKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretAccessKey = mapped
    }

    /**
     * @param value This value specifies the endpoint to access with the S3 Connector. This is an optional property; change it only if you want to try a different service endpoint or want to switch between https and http. Type: string (or Expression with resultType string).
     */
    @JvmName("kqudssykumnvmbto")
    public suspend fun serviceUrl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceUrl = mapped
    }

    /**
     * @param value The session token for the S3 temporary security credential.
     */
    @JvmName("busrswtapxetskru")
    public suspend
    fun sessionToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sessionToken = mapped
    }

    /**
     * @param value The session token for the S3 temporary security credential.
     */
    @JvmName("tkmtjbsedmrsnuqy")
    public fun sessionToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionToken = mapped
    }

    /**
     * @param value The session token for the S3 temporary security credential.
     */
    @JvmName("pryssmjgwchqeaxp")
    public fun sessionToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sessionToken = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AmazonS3'.
     */
    @JvmName("strjdvglnpduuucr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AmazonS3LinkedServiceArgs = AmazonS3LinkedServiceArgs(
        accessKeyId = accessKeyId,
        annotations = annotations,
        authenticationType = authenticationType,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        secretAccessKey = secretAccessKey,
        serviceUrl = serviceUrl,
        sessionToken = sessionToken,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
