@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureBatchLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Batch linked service.
 * @property accessKey The Azure Batch account access key.
 * @property accountName The Azure Batch account name. Type: string (or Expression with resultType string).
 * @property annotations List of tags that can be used for describing the linked service.
 * @property batchUri The Azure Batch URI. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property linkedServiceName The Azure Storage linked service reference.
 * @property parameters Parameters for linked service.
 * @property poolName The Azure Batch pool name. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureBatch'.
 */
public data class AzureBatchLinkedServiceArgs(
    public val accessKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val accountName: Output<Any>,
    public val annotations: Output<List<Any>>? = null,
    public val batchUri: Output<Any>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val poolName: Output<Any>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureBatchLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureBatchLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureBatchLinkedServiceArgs.builder()
            .accessKey(
                accessKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .batchUri(batchUri.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .poolName(poolName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureBatchLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureBatchLinkedServiceArgsBuilder internal constructor() {
    private var accessKey: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var accountName: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var batchUri: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var poolName: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value The Azure Batch account access key.
     */
    @JvmName("onxgawcberasolxa")
    public suspend
    fun accessKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accessKey = value
    }

    /**
     * @param value The Azure Batch account name. Type: string (or Expression with resultType string).
     */
    @JvmName("xceeqrflbblkcouj")
    public suspend fun accountName(`value`: Output<Any>) {
        this.accountName = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("vaemoyychqnlkltf")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("vxvxnwtryusehugy")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("kxxutbxfqqtuafgf")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The Azure Batch URI. Type: string (or Expression with resultType string).
     */
    @JvmName("adenbgwvgufnofxi")
    public suspend fun batchUri(`value`: Output<Any>) {
        this.batchUri = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("xxrymucvqifuqxrp")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("xscuneqltxttnhmn")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("iebgaojoffxuyvjn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("dkpqvleeknafkjkm")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The Azure Storage linked service reference.
     */
    @JvmName("pdprpehvjoaqusqu")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("wpqdoteucxvdkvey")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure Batch pool name. Type: string (or Expression with resultType string).
     */
    @JvmName("yirnsirffeuuessb")
    public suspend fun poolName(`value`: Output<Any>) {
        this.poolName = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureBatch'.
     */
    @JvmName("wlqmldxjbmtlowbn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The Azure Batch account access key.
     */
    @JvmName("muwobskdjjuoyfev")
    public suspend
    fun accessKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value The Azure Batch account access key.
     */
    @JvmName("xdhkssrlsvaseeey")
    public fun accessKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value The Azure Batch account access key.
     */
    @JvmName("mlyitbrwjgwldpee")
    public fun accessKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessKey = mapped
    }

    /**
     * @param value The Azure Batch account name. Type: string (or Expression with resultType string).
     */
    @JvmName("cakdcfxlkukxdhcy")
    public suspend fun accountName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("etcyrlbmqlceeowu")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hjlnqwuivlmqidia")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The Azure Batch URI. Type: string (or Expression with resultType string).
     */
    @JvmName("avlbcsfbomcovafr")
    public suspend fun batchUri(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.batchUri = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mfubknwlwdoubbys")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("nhpvtsjlaoyjjlhf")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("hcehwjnhbhtwxqqy")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("giqpixrqfslqfrbi")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("kbouupxscckicupf")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("flvkqfrflftxvssv")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The Azure Storage linked service reference.
     */
    @JvmName("bksvpuefjgwnhnfb")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument The Azure Storage linked service reference.
     */
    @JvmName("jwhvkqwovhdnppni")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hwxxhnfoacxjghxq")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("umhvttkyvhevnxov")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("qmbfgjppejpuwohp")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure Batch pool name. Type: string (or Expression with resultType string).
     */
    @JvmName("mnuyxvulkeamvvky")
    public suspend fun poolName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.poolName = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureBatch'.
     */
    @JvmName("vopoljqqlfviqmcx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureBatchLinkedServiceArgs = AzureBatchLinkedServiceArgs(
        accessKey = accessKey,
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        annotations = annotations,
        batchUri = batchUri ?: throw PulumiNullFieldException("batchUri"),
        connectVia = connectVia,
        credential = credential,
        description = description,
        encryptedCredential = encryptedCredential,
        linkedServiceName = linkedServiceName ?: throw PulumiNullFieldException("linkedServiceName"),
        parameters = parameters,
        poolName = poolName ?: throw PulumiNullFieldException("poolName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
