@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The location of azure data lake store dataset.
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'AzureDataLakeStoreLocation'.
 */
public data class AzureDataLakeStoreLocationArgs(
    public val fileName: Output<Any>? = null,
    public val folderPath: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreLocationArgs.builder()
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDataLakeStoreLocationArgs].
 */
@PulumiTagMarker
public class AzureDataLakeStoreLocationArgsBuilder internal constructor() {
    private var fileName: Output<Any>? = null

    private var folderPath: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("eptsmggembkcrsrq")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("qegmphtqgckvokhg")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AzureDataLakeStoreLocation'.
     */
    @JvmName("pdarcwcqslnpjdxn")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("fdmraaxkixljloth")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("sonxhutmmlwmnlbt")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AzureDataLakeStoreLocation'.
     */
    @JvmName("fcfcgmqhhkfqycqd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureDataLakeStoreLocationArgs = AzureDataLakeStoreLocationArgs(
        fileName = fileName,
        folderPath = folderPath,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
