@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Azure data lake store read settings.
 * @property deleteFilesAfterCompletion Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property enablePartitionDiscovery Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
 * @property fileListPath Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
 * @property listAfter Lists files after the value (exclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string).
 * @property listBefore Lists files before the value (inclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property modifiedDatetimeEnd The end of file's modified datetime. Type: string (or Expression with resultType string).
 * @property modifiedDatetimeStart The start of file's modified datetime. Type: string (or Expression with resultType string).
 * @property partitionRootPath Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
 * @property recursive If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
 * @property type The read setting type.
 * Expected value is 'AzureDataLakeStoreReadSettings'.
 * @property wildcardFileName ADLS wildcardFileName. Type: string (or Expression with resultType string).
 * @property wildcardFolderPath ADLS wildcardFolderPath. Type: string (or Expression with resultType string).
 */
public data class AzureDataLakeStoreReadSettingsArgs(
    public val deleteFilesAfterCompletion: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val enablePartitionDiscovery: Output<Any>? = null,
    public val fileListPath: Output<Any>? = null,
    public val listAfter: Output<Any>? = null,
    public val listBefore: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val modifiedDatetimeEnd: Output<Any>? = null,
    public val modifiedDatetimeStart: Output<Any>? = null,
    public val partitionRootPath: Output<Any>? = null,
    public val recursive: Output<Any>? = null,
    public val type: Output<String>,
    public val wildcardFileName: Output<Any>? = null,
    public val wildcardFolderPath: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreReadSettingsArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDataLakeStoreReadSettingsArgs.builder()
            .deleteFilesAfterCompletion(deleteFilesAfterCompletion?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .enablePartitionDiscovery(enablePartitionDiscovery?.applyValue({ args0 -> args0 }))
            .fileListPath(fileListPath?.applyValue({ args0 -> args0 }))
            .listAfter(listAfter?.applyValue({ args0 -> args0 }))
            .listBefore(listBefore?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeEnd(modifiedDatetimeEnd?.applyValue({ args0 -> args0 }))
            .modifiedDatetimeStart(modifiedDatetimeStart?.applyValue({ args0 -> args0 }))
            .partitionRootPath(partitionRootPath?.applyValue({ args0 -> args0 }))
            .recursive(recursive?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .wildcardFileName(wildcardFileName?.applyValue({ args0 -> args0 }))
            .wildcardFolderPath(wildcardFolderPath?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDataLakeStoreReadSettingsArgs].
 */
@PulumiTagMarker
public class AzureDataLakeStoreReadSettingsArgsBuilder internal constructor() {
    private var deleteFilesAfterCompletion: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var enablePartitionDiscovery: Output<Any>? = null

    private var fileListPath: Output<Any>? = null

    private var listAfter: Output<Any>? = null

    private var listBefore: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var modifiedDatetimeEnd: Output<Any>? = null

    private var modifiedDatetimeStart: Output<Any>? = null

    private var partitionRootPath: Output<Any>? = null

    private var recursive: Output<Any>? = null

    private var type: Output<String>? = null

    private var wildcardFileName: Output<Any>? = null

    private var wildcardFolderPath: Output<Any>? = null

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qxxejotymnhgfwuv")
    public suspend fun deleteFilesAfterCompletion(`value`: Output<Any>) {
        this.deleteFilesAfterCompletion = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("aaqwsyafhunxjiec")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("uvxolhblrxhqsvet")
    public suspend fun enablePartitionDiscovery(`value`: Output<Any>) {
        this.enablePartitionDiscovery = value
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("kyofqvrxnedeajwh")
    public suspend fun fileListPath(`value`: Output<Any>) {
        this.fileListPath = value
    }

    /**
     * @param value Lists files after the value (exclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("awvrubdaemimlsir")
    public suspend fun listAfter(`value`: Output<Any>) {
        this.listAfter = value
    }

    /**
     * @param value Lists files before the value (inclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("skeivgvgjdxcaibs")
    public suspend fun listBefore(`value`: Output<Any>) {
        this.listBefore = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("vgrmnqwekotjinrk")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("xvmqyevqbfipudqa")
    public suspend fun modifiedDatetimeEnd(`value`: Output<Any>) {
        this.modifiedDatetimeEnd = value
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("cpxdlvlejdtcmhec")
    public suspend fun modifiedDatetimeStart(`value`: Output<Any>) {
        this.modifiedDatetimeStart = value
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("vnwtjeblewrttvhm")
    public suspend fun partitionRootPath(`value`: Output<Any>) {
        this.partitionRootPath = value
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("elocngecmiuydlne")
    public suspend fun recursive(`value`: Output<Any>) {
        this.recursive = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'AzureDataLakeStoreReadSettings'.
     */
    @JvmName("gnhtmxlqdjxcijyf")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value ADLS wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("klsuwxndnowsrpad")
    public suspend fun wildcardFileName(`value`: Output<Any>) {
        this.wildcardFileName = value
    }

    /**
     * @param value ADLS wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("fnvbkvukthbowrbc")
    public suspend fun wildcardFolderPath(`value`: Output<Any>) {
        this.wildcardFolderPath = value
    }

    /**
     * @param value Indicates whether the source files need to be deleted after copy completion. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("kmwiuthkmakhcsse")
    public suspend fun deleteFilesAfterCompletion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.deleteFilesAfterCompletion = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("hedrisvbxcarwjmy")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Indicates whether to enable partition discovery. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("vmvegrxyqbchpjwm")
    public suspend fun enablePartitionDiscovery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enablePartitionDiscovery = mapped
    }

    /**
     * @param value Point to a text file that lists each file (relative path to the path configured in the dataset) that you want to copy. Type: string (or Expression with resultType string).
     */
    @JvmName("qgevflfhdwydnpqj")
    public suspend fun fileListPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileListPath = mapped
    }

    /**
     * @param value Lists files after the value (exclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("mbataflamrkolfaw")
    public suspend fun listAfter(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listAfter = mapped
    }

    /**
     * @param value Lists files before the value (inclusive) based on file/folder names’ lexicographical order. Applies under the folderPath in data set, and filter files/sub-folders under the folderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("srijorxrmfydcnfy")
    public suspend fun listBefore(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.listBefore = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("rvhcxwhhnbvekyue")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The end of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("ywhheybmxgwlnfqt")
    public suspend fun modifiedDatetimeEnd(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeEnd = mapped
    }

    /**
     * @param value The start of file's modified datetime. Type: string (or Expression with resultType string).
     */
    @JvmName("xmmufpxrfljqfusr")
    public suspend fun modifiedDatetimeStart(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.modifiedDatetimeStart = mapped
    }

    /**
     * @param value Specify the root path where partition discovery starts from. Type: string (or Expression with resultType string).
     */
    @JvmName("njlmoadtjpasjofg")
    public suspend fun partitionRootPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.partitionRootPath = mapped
    }

    /**
     * @param value If true, files under the folder path will be read recursively. Default is true. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("crsnigtvoeiroirj")
    public suspend fun recursive(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recursive = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'AzureDataLakeStoreReadSettings'.
     */
    @JvmName("fxcolkrqaysjlghd")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value ADLS wildcardFileName. Type: string (or Expression with resultType string).
     */
    @JvmName("rywiqrbjcqabrxff")
    public suspend fun wildcardFileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFileName = mapped
    }

    /**
     * @param value ADLS wildcardFolderPath. Type: string (or Expression with resultType string).
     */
    @JvmName("xayxqncnvwbmfkgc")
    public suspend fun wildcardFolderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.wildcardFolderPath = mapped
    }

    internal fun build(): AzureDataLakeStoreReadSettingsArgs = AzureDataLakeStoreReadSettingsArgs(
        deleteFilesAfterCompletion = deleteFilesAfterCompletion,
        disableMetricsCollection = disableMetricsCollection,
        enablePartitionDiscovery = enablePartitionDiscovery,
        fileListPath = fileListPath,
        listAfter = listAfter,
        listBefore = listBefore,
        maxConcurrentConnections = maxConcurrentConnections,
        modifiedDatetimeEnd = modifiedDatetimeEnd,
        modifiedDatetimeStart = modifiedDatetimeStart,
        partitionRootPath = partitionRootPath,
        recursive = recursive,
        type = type ?: throw PulumiNullFieldException("type"),
        wildcardFileName = wildcardFileName,
        wildcardFolderPath = wildcardFolderPath,
    )
}
