@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure Databricks Delta Lake linked service.
 * @property accessToken Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property clusterId The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property domain <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property type Type of linked service.
 * Expected value is 'AzureDatabricksDeltaLake'.
 * @property workspaceResourceId Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
 */
public data class AzureDatabricksDeltaLakeLinkedServiceArgs(
    public val accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val annotations: Output<List<Any>>? = null,
    public val clusterId: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val domain: Output<Any>,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val type: Output<String>,
    public val workspaceResourceId: Output<Any>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeLinkedServiceArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeLinkedServiceArgs.builder()
            .accessToken(
                accessToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .clusterId(clusterId?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .domain(domain.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .workspaceResourceId(workspaceResourceId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDatabricksDeltaLakeLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureDatabricksDeltaLakeLinkedServiceArgsBuilder internal constructor() {
    private var accessToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var annotations: Output<List<Any>>? = null

    private var clusterId: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var description: Output<String>? = null

    private var domain: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var type: Output<String>? = null

    private var workspaceResourceId: Output<Any>? = null

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("nngxshkupoablocb")
    public suspend
    fun accessToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.accessToken = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("xuhguaipgewgdtjo")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("sptxxuucnydqdiuc")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("desyjudywucdksdn")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
     */
    @JvmName("pxuxbfwarholumyx")
    public suspend fun clusterId(`value`: Output<Any>) {
        this.clusterId = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("ofnlvrqaxgtvlqea")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("lrvgkgdsngidloys")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("hvgsavtgdjebeomq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
     */
    @JvmName("gxaypmwrvigydbvi")
    public suspend fun domain(`value`: Output<Any>) {
        this.domain = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("pqxtuxlbloisriqv")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("blrtasrwsoamqdyi")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureDatabricksDeltaLake'.
     */
    @JvmName("nmmcdoofpwbhwhfu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
     */
    @JvmName("nieurstxoxkocxek")
    public suspend fun workspaceResourceId(`value`: Output<Any>) {
        this.workspaceResourceId = value
    }

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("pwdikjihmxyuetij")
    public suspend
    fun accessToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("kjsyeantutljicjy")
    public fun accessToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value Access token for databricks REST API. Refer to https://docs.azuredatabricks.net/api/latest/authentication.html. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("dvjpeosesjoqtrbs")
    public fun accessToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessToken = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("unxhrtuphuopbkjv")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("vxyipjlqisacuuhv")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The id of an existing interactive cluster that will be used for all runs of this job. Type: string (or Expression with resultType string).
     */
    @JvmName("apqisvfddovwrkqb")
    public suspend fun clusterId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clusterId = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("dqpxhextcyrawcow")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("jmjniwramrvqqxgn")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("yesgnaubwrccpgfq")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("eayiqllqosucgqqp")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ewhqfrwtcoobcikk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value <REGION>.azuredatabricks.net, domain name of your Databricks deployment. Type: string (or Expression with resultType string).
     */
    @JvmName("rtcubjidtwjbdpug")
    public suspend fun domain(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.domain = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("bnrekbwyylglmvse")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("efppcondsltlvpeo")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("awgosorfinwuvxqi")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("rceynnggghcumuoi")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureDatabricksDeltaLake'.
     */
    @JvmName("igsmflnbakqlbvsg")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Workspace resource id for databricks REST API. Type: string (or Expression with resultType string).
     */
    @JvmName("udyfhudvthlgkbsc")
    public suspend fun workspaceResourceId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.workspaceResourceId = mapped
    }

    internal fun build(): AzureDatabricksDeltaLakeLinkedServiceArgs =
        AzureDatabricksDeltaLakeLinkedServiceArgs(
            accessToken = accessToken,
            annotations = annotations,
            clusterId = clusterId,
            connectVia = connectVia,
            credential = credential,
            description = description,
            domain = domain ?: throw PulumiNullFieldException("domain"),
            encryptedCredential = encryptedCredential,
            parameters = parameters,
            type = type ?: throw PulumiNullFieldException("type"),
            workspaceResourceId = workspaceResourceId,
        )
}
