@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSinkArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * A copy activity Azure Databricks Delta Lake sink.
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property importSettings Azure Databricks Delta Lake import settings.
 * @property maxConcurrentConnections The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
 * @property preCopyScript SQL pre-copy script. Type: string (or Expression with resultType string).
 * @property sinkRetryCount Sink retry count. Type: integer (or Expression with resultType integer).
 * @property sinkRetryWait Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy sink type.
 * Expected value is 'AzureDatabricksDeltaLakeSink'.
 * @property writeBatchSize Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
 * @property writeBatchTimeout Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 */
public data class AzureDatabricksDeltaLakeSinkArgs(
    public val disableMetricsCollection: Output<Any>? = null,
    public val importSettings: Output<AzureDatabricksDeltaLakeImportCommandArgs>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val preCopyScript: Output<Any>? = null,
    public val sinkRetryCount: Output<Any>? = null,
    public val sinkRetryWait: Output<Any>? = null,
    public val type: Output<String>,
    public val writeBatchSize: Output<Any>? = null,
    public val writeBatchTimeout: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSinkArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSinkArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureDatabricksDeltaLakeSinkArgs.builder()
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .importSettings(importSettings?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .preCopyScript(preCopyScript?.applyValue({ args0 -> args0 }))
            .sinkRetryCount(sinkRetryCount?.applyValue({ args0 -> args0 }))
            .sinkRetryWait(sinkRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .writeBatchSize(writeBatchSize?.applyValue({ args0 -> args0 }))
            .writeBatchTimeout(writeBatchTimeout?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureDatabricksDeltaLakeSinkArgs].
 */
@PulumiTagMarker
public class AzureDatabricksDeltaLakeSinkArgsBuilder internal constructor() {
    private var disableMetricsCollection: Output<Any>? = null

    private var importSettings: Output<AzureDatabricksDeltaLakeImportCommandArgs>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var preCopyScript: Output<Any>? = null

    private var sinkRetryCount: Output<Any>? = null

    private var sinkRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    private var writeBatchSize: Output<Any>? = null

    private var writeBatchTimeout: Output<Any>? = null

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("qdaugovqfrldxetg")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value Azure Databricks Delta Lake import settings.
     */
    @JvmName("sqkjeqlbxbxkodcw")
    public suspend fun importSettings(`value`: Output<AzureDatabricksDeltaLakeImportCommandArgs>) {
        this.importSettings = value
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("dsaqkbhbpktnjtdv")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("bljdfpqlyntwxrcn")
    public suspend fun preCopyScript(`value`: Output<Any>) {
        this.preCopyScript = value
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("nmephuyvesmorrfl")
    public suspend fun sinkRetryCount(`value`: Output<Any>) {
        this.sinkRetryCount = value
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("vfffesxbhcuhijrl")
    public suspend fun sinkRetryWait(`value`: Output<Any>) {
        this.sinkRetryWait = value
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'AzureDatabricksDeltaLakeSink'.
     */
    @JvmName("irvwqfphqnboucap")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("tnojcmunfwskkrdh")
    public suspend fun writeBatchSize(`value`: Output<Any>) {
        this.writeBatchSize = value
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("bhpbrbewdpkymjcj")
    public suspend fun writeBatchTimeout(`value`: Output<Any>) {
        this.writeBatchTimeout = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("puwahqblnxsqhnbl")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value Azure Databricks Delta Lake import settings.
     */
    @JvmName("lxcgvyerlbayfpee")
    public suspend fun importSettings(`value`: AzureDatabricksDeltaLakeImportCommandArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.importSettings = mapped
    }

    /**
     * @param argument Azure Databricks Delta Lake import settings.
     */
    @JvmName("wkoctkarfnrqirna")
    public suspend
    fun importSettings(argument: suspend AzureDatabricksDeltaLakeImportCommandArgsBuilder.() -> Unit) {
        val toBeMapped = AzureDatabricksDeltaLakeImportCommandArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.importSettings = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the sink data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ffengcykglpqeajt")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value SQL pre-copy script. Type: string (or Expression with resultType string).
     */
    @JvmName("axjnmkucrbsmmecu")
    public suspend fun preCopyScript(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preCopyScript = mapped
    }

    /**
     * @param value Sink retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("mxsxmregcwwhfehb")
    public suspend fun sinkRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryCount = mapped
    }

    /**
     * @param value Sink retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("aeqbdbltxaypjpak")
    public suspend fun sinkRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sinkRetryWait = mapped
    }

    /**
     * @param value Copy sink type.
     * Expected value is 'AzureDatabricksDeltaLakeSink'.
     */
    @JvmName("kyjkbkblptvsfoyn")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Write batch size. Type: integer (or Expression with resultType integer), minimum: 0.
     */
    @JvmName("ferdgoodtqyhcduv")
    public suspend fun writeBatchSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchSize = mapped
    }

    /**
     * @param value Write batch timeout. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("caxihkqlhgpfcmgj")
    public suspend fun writeBatchTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.writeBatchTimeout = mapped
    }

    internal fun build(): AzureDatabricksDeltaLakeSinkArgs = AzureDatabricksDeltaLakeSinkArgs(
        disableMetricsCollection = disableMetricsCollection,
        importSettings = importSettings,
        maxConcurrentConnections = maxConcurrentConnections,
        preCopyScript = preCopyScript,
        sinkRetryCount = sinkRetryCount,
        sinkRetryWait = sinkRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
        writeBatchSize = writeBatchSize,
        writeBatchTimeout = writeBatchTimeout,
    )
}
