@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLocationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * The location of file server dataset.
 * @property fileName Specify the file name of dataset. Type: string (or Expression with resultType string).
 * @property folderPath Specify the folder path of dataset. Type: string (or Expression with resultType string)
 * @property type Type of dataset storage location.
 * Expected value is 'AzureFileStorageLocation'.
 */
public data class AzureFileStorageLocationArgs(
    public val fileName: Output<Any>? = null,
    public val folderPath: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLocationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLocationArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureFileStorageLocationArgs.builder()
            .fileName(fileName?.applyValue({ args0 -> args0 }))
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureFileStorageLocationArgs].
 */
@PulumiTagMarker
public class AzureFileStorageLocationArgsBuilder internal constructor() {
    private var fileName: Output<Any>? = null

    private var folderPath: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("cykgvvywuqmsjmyl")
    public suspend fun fileName(`value`: Output<Any>) {
        this.fileName = value
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("hyykpsfwdvmmgjxm")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AzureFileStorageLocation'.
     */
    @JvmName("wudahmpfvmcqnfsy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specify the file name of dataset. Type: string (or Expression with resultType string).
     */
    @JvmName("jgudjmoysdmbwvjf")
    public suspend fun fileName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.fileName = mapped
    }

    /**
     * @param value Specify the folder path of dataset. Type: string (or Expression with resultType string)
     */
    @JvmName("djhnlgyavbfkgupi")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Type of dataset storage location.
     * Expected value is 'AzureFileStorageLocation'.
     */
    @JvmName("wmmcbhnskdmcuyco")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureFileStorageLocationArgs = AzureFileStorageLocationArgs(
        fileName = fileName,
        folderPath = folderPath,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
