@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureKeyVaultSecretReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Azure Key Vault secret reference.
 * @property secretName The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
 * @property secretVersion The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
 * @property store The Azure Key Vault linked service reference.
 * @property type Type of the secret.
 * Expected value is 'AzureKeyVaultSecret'.
 */
public data class AzureKeyVaultSecretReferenceArgs(
    public val secretName: Output<Any>,
    public val secretVersion: Output<Any>? = null,
    public val store: Output<LinkedServiceReferenceArgs>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureKeyVaultSecretReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureKeyVaultSecretReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureKeyVaultSecretReferenceArgs.builder()
            .secretName(secretName.applyValue({ args0 -> args0 }))
            .secretVersion(secretVersion?.applyValue({ args0 -> args0 }))
            .store(store.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureKeyVaultSecretReferenceArgs].
 */
@PulumiTagMarker
public class AzureKeyVaultSecretReferenceArgsBuilder internal constructor() {
    private var secretName: Output<Any>? = null

    private var secretVersion: Output<Any>? = null

    private var store: Output<LinkedServiceReferenceArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
     */
    @JvmName("pihjvbfttgyntwgk")
    public suspend fun secretName(`value`: Output<Any>) {
        this.secretName = value
    }

    /**
     * @param value The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
     */
    @JvmName("enqfceqdawbudkjd")
    public suspend fun secretVersion(`value`: Output<Any>) {
        this.secretVersion = value
    }

    /**
     * @param value The Azure Key Vault linked service reference.
     */
    @JvmName("hjtkpawxanrixkbk")
    public suspend fun store(`value`: Output<LinkedServiceReferenceArgs>) {
        this.store = value
    }

    /**
     * @param value Type of the secret.
     * Expected value is 'AzureKeyVaultSecret'.
     */
    @JvmName("caxyphkvpewkfbjt")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The name of the secret in Azure Key Vault. Type: string (or Expression with resultType string).
     */
    @JvmName("ohgnhsvykbornnmi")
    public suspend fun secretName(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.secretName = mapped
    }

    /**
     * @param value The version of the secret in Azure Key Vault. The default value is the latest version of the secret. Type: string (or Expression with resultType string).
     */
    @JvmName("pmhjrgphwwqhhnbe")
    public suspend fun secretVersion(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secretVersion = mapped
    }

    /**
     * @param value The Azure Key Vault linked service reference.
     */
    @JvmName("carqbwmfeaimtmya")
    public suspend fun store(`value`: LinkedServiceReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.store = mapped
    }

    /**
     * @param argument The Azure Key Vault linked service reference.
     */
    @JvmName("xqwbwgpkeepqqjfy")
    public suspend fun store(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.store = mapped
    }

    /**
     * @param value Type of the secret.
     * Expected value is 'AzureKeyVaultSecret'.
     */
    @JvmName("jvvqsbrslgdsyvmu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureKeyVaultSecretReferenceArgs = AzureKeyVaultSecretReferenceArgs(
        secretName = secretName ?: throw PulumiNullFieldException("secretName"),
        secretVersion = secretVersion,
        store = store ?: throw PulumiNullFieldException("store"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
