@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs.builder
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Azure SQL Data Warehouse linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property azureCloudType Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
 * @property connectVia The integration runtime reference.
 * @property connectionString The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
 * @property credential The credential reference containing authentication information.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property parameters Parameters for linked service.
 * @property password The Azure key vault secret reference of password in connection string.
 * @property servicePrincipalId The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
 * @property servicePrincipalKey The key of the service principal used to authenticate against Azure SQL Data Warehouse.
 * @property tenant The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
 * @property type Type of linked service.
 * Expected value is 'AzureSqlDW'.
 */
public data class AzureSqlDWLinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val azureCloudType: Output<Any>? = null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val connectionString: Output<Any>,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<AzureKeyVaultSecretReferenceArgs>? = null,
    public val servicePrincipalId: Output<Any>? = null,
    public val servicePrincipalKey:
    Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val tenant: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.AzureSqlDWLinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .azureCloudType(azureCloudType?.applyValue({ args0 -> args0 }))
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .connectionString(connectionString.applyValue({ args0 -> args0 }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(password?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .servicePrincipalId(servicePrincipalId?.applyValue({ args0 -> args0 }))
            .servicePrincipalKey(
                servicePrincipalKey?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .tenant(tenant?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [AzureSqlDWLinkedServiceArgs].
 */
@PulumiTagMarker
public class AzureSqlDWLinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var azureCloudType: Output<Any>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var connectionString: Output<Any>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<AzureKeyVaultSecretReferenceArgs>? = null

    private var servicePrincipalId: Output<Any>? = null

    private var servicePrincipalKey:
        Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var tenant: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("mbgpgftiomipjkmh")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("dkeeasywbqfhfrqx")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("xjhdjaitnfjoaswi")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("thcnppqhtvkqatok")
    public suspend fun azureCloudType(`value`: Output<Any>) {
        this.azureCloudType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("edpatrutctrqvenc")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("sqjnysodsaqjxldt")
    public suspend fun connectionString(`value`: Output<Any>) {
        this.connectionString = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("kguqdqbdddvahxqq")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("bwrtfsviumpqlcuu")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("mkkefjmpsfvjpfid")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("yqosknntoxpydsvh")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("hrbpoyywvxnmbuct")
    public suspend fun password(`value`: Output<AzureKeyVaultSecretReferenceArgs>) {
        this.password = value
    }

    /**
     * @param value The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("aptottwfypfdigjn")
    public suspend fun servicePrincipalId(`value`: Output<Any>) {
        this.servicePrincipalId = value
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("gcqauiymikklbqla")
    public suspend
    fun servicePrincipalKey(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.servicePrincipalKey = value
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("pwytptggjrkccysq")
    public suspend fun tenant(`value`: Output<Any>) {
        this.tenant = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureSqlDW'.
     */
    @JvmName("pimceyhnceorrgjd")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("hlpqqmbksejoaynm")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hfhjyushiwhgvrsf")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Indicates the azure cloud type of the service principle auth. Allowed values are AzurePublic, AzureChina, AzureUsGovernment, AzureGermany. Default value is the data factory regions’ cloud type. Type: string (or Expression with resultType string).
     */
    @JvmName("iwywukvbymilftmc")
    public suspend fun azureCloudType(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.azureCloudType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("mhedefujvrdxoukb")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("qndcviefmcfmhtar")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value The connection string. Type: string, SecureString or AzureKeyVaultSecretReference. Type: string, SecureString or AzureKeyVaultSecretReference.
     */
    @JvmName("lkkuamnccrivmvxb")
    public suspend fun connectionString(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectionString = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("atdwpblxhkvacanv")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("hgnopxqeeuqpqtlu")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("ngbirejkhpguavbw")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("qelraombrlxrpbff")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("hbxgluohclppxluv")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("ibdjypqptevymren")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("wqssmyudqagtskiy")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The Azure key vault secret reference of password in connection string.
     */
    @JvmName("umvjkuvfrwuvdnlk")
    public suspend fun password(`value`: AzureKeyVaultSecretReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param argument The Azure key vault secret reference of password in connection string.
     */
    @JvmName("lmyxrnuvmlrfoxmw")
    public suspend
    fun password(argument: suspend AzureKeyVaultSecretReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = AzureKeyVaultSecretReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.password = mapped
    }

    /**
     * @param value The ID of the service principal used to authenticate against Azure SQL Data Warehouse. Type: string (or Expression with resultType string).
     */
    @JvmName("yxgyyrhoqvispnut")
    public suspend fun servicePrincipalId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalId = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("doujkcejnlbgbryg")
    public suspend
    fun servicePrincipalKey(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("ifxuiuhfgeciopjw")
    public fun servicePrincipalKey(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The key of the service principal used to authenticate against Azure SQL Data Warehouse.
     */
    @JvmName("nalwaiqywtvbveai")
    public fun servicePrincipalKey(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.servicePrincipalKey = mapped
    }

    /**
     * @param value The name or ID of the tenant to which the service principal belongs. Type: string (or Expression with resultType string).
     */
    @JvmName("kfnkecsbqyktchrh")
    public suspend fun tenant(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tenant = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'AzureSqlDW'.
     */
    @JvmName("rgeolwtvkgsrmmhu")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): AzureSqlDWLinkedServiceArgs = AzureSqlDWLinkedServiceArgs(
        annotations = annotations,
        azureCloudType = azureCloudType,
        connectVia = connectVia,
        connectionString = connectionString ?: throw PulumiNullFieldException("connectionString"),
        credential = credential,
        description = description,
        encryptedCredential = encryptedCredential,
        parameters = parameters,
        password = password,
        servicePrincipalId = servicePrincipalId,
        servicePrincipalKey = servicePrincipalKey,
        tenant = tenant,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
