@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ChainingTriggerArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Trigger that allows the referenced pipeline to depend on other pipeline runs based on runDimension Name/Value pairs. Upstream pipelines should declare the same runDimension Name and their runs should have the values for those runDimensions. The referenced pipeline run would be triggered if the values for the runDimension match for all upstream pipeline runs.
 * @property annotations List of tags that can be used for describing the trigger.
 * @property dependsOn Upstream Pipelines.
 * @property description Trigger description.
 * @property pipeline Pipeline for which runs are created when all upstream pipelines complete successfully.
 * @property runDimension Run Dimension property that needs to be emitted by upstream pipelines.
 * @property type Trigger type.
 * Expected value is 'ChainingTrigger'.
 */
public data class ChainingTriggerArgs(
    public val annotations: Output<List<Any>>? = null,
    public val dependsOn: Output<List<PipelineReferenceArgs>>,
    public val description: Output<String>? = null,
    public val pipeline: Output<TriggerPipelineReferenceArgs>,
    public val runDimension: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ChainingTriggerArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ChainingTriggerArgs =
        com.pulumi.azurenative.datafactory.inputs.ChainingTriggerArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .dependsOn(
                dependsOn.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .pipeline(pipeline.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .runDimension(runDimension.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ChainingTriggerArgs].
 */
@PulumiTagMarker
public class ChainingTriggerArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var dependsOn: Output<List<PipelineReferenceArgs>>? = null

    private var description: Output<String>? = null

    private var pipeline: Output<TriggerPipelineReferenceArgs>? = null

    private var runDimension: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("twxfeurxvxmeookn")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("ixfnbhebeihgtbdr")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("pqdiyecqmxbofrkm")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value Upstream Pipelines.
     */
    @JvmName("vepvldxharlypepi")
    public suspend fun dependsOn(`value`: Output<List<PipelineReferenceArgs>>) {
        this.dependsOn = value
    }

    @JvmName("ckguebnpjyyvtqkl")
    public suspend fun dependsOn(vararg values: Output<PipelineReferenceArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Upstream Pipelines.
     */
    @JvmName("ayhprnxesgrpfnvc")
    public suspend fun dependsOn(values: List<Output<PipelineReferenceArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("ohlcpqneqknkkxee")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Pipeline for which runs are created when all upstream pipelines complete successfully.
     */
    @JvmName("rydwwathiywjakyu")
    public suspend fun pipeline(`value`: Output<TriggerPipelineReferenceArgs>) {
        this.pipeline = value
    }

    /**
     * @param value Run Dimension property that needs to be emitted by upstream pipelines.
     */
    @JvmName("gtspswqggxdlcvnm")
    public suspend fun runDimension(`value`: Output<String>) {
        this.runDimension = value
    }

    /**
     * @param value Trigger type.
     * Expected value is 'ChainingTrigger'.
     */
    @JvmName("jandpxrsifwlmcvs")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the trigger.
     */
    @JvmName("oanbtebhgwjqtpot")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the trigger.
     */
    @JvmName("gbpqgsexyiqnedys")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value Upstream Pipelines.
     */
    @JvmName("esdonamwpokldkcv")
    public suspend fun dependsOn(`value`: List<PipelineReferenceArgs>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Upstream Pipelines.
     */
    @JvmName("ggerovrjvtgogljb")
    public suspend fun dependsOn(argument: List<suspend PipelineReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Upstream Pipelines.
     */
    @JvmName("twblmwjuuraoaxjn")
    public suspend fun dependsOn(vararg argument: suspend PipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PipelineReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Upstream Pipelines.
     */
    @JvmName("uaghchxxgsxiflwg")
    public suspend fun dependsOn(argument: suspend PipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PipelineReferenceArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Upstream Pipelines.
     */
    @JvmName("yaldkyabgaotqvtn")
    public suspend fun dependsOn(vararg values: PipelineReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Trigger description.
     */
    @JvmName("byxhyurrtyqptoxk")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Pipeline for which runs are created when all upstream pipelines complete successfully.
     */
    @JvmName("eofgldilcsegdgtp")
    public suspend fun pipeline(`value`: TriggerPipelineReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.pipeline = mapped
    }

    /**
     * @param argument Pipeline for which runs are created when all upstream pipelines complete successfully.
     */
    @JvmName("fjbggpqdwbujofqe")
    public suspend fun pipeline(argument: suspend TriggerPipelineReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = TriggerPipelineReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.pipeline = mapped
    }

    /**
     * @param value Run Dimension property that needs to be emitted by upstream pipelines.
     */
    @JvmName("dliywgkvufjhwqyx")
    public suspend fun runDimension(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runDimension = mapped
    }

    /**
     * @param value Trigger type.
     * Expected value is 'ChainingTrigger'.
     */
    @JvmName("owtakmuvvqusierb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ChainingTriggerArgs = ChainingTriggerArgs(
        annotations = annotations,
        dependsOn = dependsOn ?: throw PulumiNullFieldException("dependsOn"),
        description = description,
        pipeline = pipeline ?: throw PulumiNullFieldException("pipeline"),
        runDimension = runDimension ?: throw PulumiNullFieldException("runDimension"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
