@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CosmosDbSqlApiSourceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A copy activity Azure CosmosDB (SQL API) Collection source.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property detectDatetime Whether detect primitive values as datetime values. Type: boolean (or Expression with resultType boolean).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property pageSize Page size of the result. Type: integer (or Expression with resultType integer).
 * @property preferredRegions Preferred regions. Type: array of strings (or Expression with resultType array of strings).
 * @property query SQL API query. Type: string (or Expression with resultType string).
 * @property sourceRetryCount Source retry count. Type: integer (or Expression with resultType integer).
 * @property sourceRetryWait Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
 * @property type Copy source type.
 * Expected value is 'CosmosDbSqlApiSource'.
 */
public data class CosmosDbSqlApiSourceArgs(
    public val additionalColumns: Output<Any>? = null,
    public val detectDatetime: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val pageSize: Output<Any>? = null,
    public val preferredRegions: Output<Any>? = null,
    public val query: Output<Any>? = null,
    public val sourceRetryCount: Output<Any>? = null,
    public val sourceRetryWait: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CosmosDbSqlApiSourceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CosmosDbSqlApiSourceArgs =
        com.pulumi.azurenative.datafactory.inputs.CosmosDbSqlApiSourceArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .detectDatetime(detectDatetime?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .pageSize(pageSize?.applyValue({ args0 -> args0 }))
            .preferredRegions(preferredRegions?.applyValue({ args0 -> args0 }))
            .query(query?.applyValue({ args0 -> args0 }))
            .sourceRetryCount(sourceRetryCount?.applyValue({ args0 -> args0 }))
            .sourceRetryWait(sourceRetryWait?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [CosmosDbSqlApiSourceArgs].
 */
@PulumiTagMarker
public class CosmosDbSqlApiSourceArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var detectDatetime: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var pageSize: Output<Any>? = null

    private var preferredRegions: Output<Any>? = null

    private var query: Output<Any>? = null

    private var sourceRetryCount: Output<Any>? = null

    private var sourceRetryWait: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("wmtkogsfnrtjtwxb")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value Whether detect primitive values as datetime values. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jfchaqakeveudfoo")
    public suspend fun detectDatetime(`value`: Output<Any>) {
        this.detectDatetime = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("fgqvchcljewwfnat")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ubmspbfgeukibtmj")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Page size of the result. Type: integer (or Expression with resultType integer).
     */
    @JvmName("kobpcbrgqhkgbioa")
    public suspend fun pageSize(`value`: Output<Any>) {
        this.pageSize = value
    }

    /**
     * @param value Preferred regions. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("orfevkwyvkiohhru")
    public suspend fun preferredRegions(`value`: Output<Any>) {
        this.preferredRegions = value
    }

    /**
     * @param value SQL API query. Type: string (or Expression with resultType string).
     */
    @JvmName("vfeauptpekpvggdq")
    public suspend fun query(`value`: Output<Any>) {
        this.query = value
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("unutfjyabsfxjsxh")
    public suspend fun sourceRetryCount(`value`: Output<Any>) {
        this.sourceRetryCount = value
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("hmifhrqmliqihnde")
    public suspend fun sourceRetryWait(`value`: Output<Any>) {
        this.sourceRetryWait = value
    }

    /**
     * @param value Copy source type.
     * Expected value is 'CosmosDbSqlApiSource'.
     */
    @JvmName("nfglkiveguhftift")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("tchioxiutkbkqueg")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value Whether detect primitive values as datetime values. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("pygetayveaxkncut")
    public suspend fun detectDatetime(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.detectDatetime = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("jtuqynoqdftsmesi")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("dsxncwpavfneykap")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Page size of the result. Type: integer (or Expression with resultType integer).
     */
    @JvmName("ffdjtotcjbwqrduw")
    public suspend fun pageSize(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.pageSize = mapped
    }

    /**
     * @param value Preferred regions. Type: array of strings (or Expression with resultType array of strings).
     */
    @JvmName("xbnecfhobenbfuqq")
    public suspend fun preferredRegions(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.preferredRegions = mapped
    }

    /**
     * @param value SQL API query. Type: string (or Expression with resultType string).
     */
    @JvmName("ckswwapbwnoworhl")
    public suspend fun query(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.query = mapped
    }

    /**
     * @param value Source retry count. Type: integer (or Expression with resultType integer).
     */
    @JvmName("vivsudsuuosiiqyu")
    public suspend fun sourceRetryCount(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryCount = mapped
    }

    /**
     * @param value Source retry wait. Type: string (or Expression with resultType string), pattern: ((\d+)\.)?(\d\d):(60|([0-5][0-9])):(60|([0-5][0-9])).
     */
    @JvmName("abjypfbebqoxufrl")
    public suspend fun sourceRetryWait(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceRetryWait = mapped
    }

    /**
     * @param value Copy source type.
     * Expected value is 'CosmosDbSqlApiSource'.
     */
    @JvmName("qsplesgerxjviwvl")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): CosmosDbSqlApiSourceArgs = CosmosDbSqlApiSourceArgs(
        additionalColumns = additionalColumns,
        detectDatetime = detectDatetime,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        pageSize = pageSize,
        preferredRegions = preferredRegions,
        query = query,
        sourceRetryCount = sourceRetryCount,
        sourceRetryWait = sourceRetryWait,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
