@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.CustomActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Custom activity type.
 * @property autoUserSpecification Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double).
 * @property command Command for custom activity Type: string (or Expression with resultType string).
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property extendedProperties User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
 * @property folderPath Folder path for resource files Type: string (or Expression with resultType string).
 * @property linkedServiceName Linked service reference.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property referenceObjects Reference objects
 * @property resourceLinkedService Resource linked service reference.
 * @property retentionTimeInDays The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'Custom'.
 * @property userProperties Activity user properties.
 */
public data class CustomActivityArgs(
    public val autoUserSpecification: Output<Any>? = null,
    public val command: Output<Any>,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val extendedProperties: Output<Map<String, Any>>? = null,
    public val folderPath: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val referenceObjects: Output<CustomActivityReferenceObjectArgs>? = null,
    public val resourceLinkedService: Output<LinkedServiceReferenceArgs>? = null,
    public val retentionTimeInDays: Output<Any>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.CustomActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.CustomActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.CustomActivityArgs.builder()
            .autoUserSpecification(autoUserSpecification?.applyValue({ args0 -> args0 }))
            .command(command.applyValue({ args0 -> args0 }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .extendedProperties(
                extendedProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .folderPath(folderPath?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .referenceObjects(referenceObjects?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceLinkedService(
                resourceLinkedService?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .retentionTimeInDays(retentionTimeInDays?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [CustomActivityArgs].
 */
@PulumiTagMarker
public class CustomActivityArgsBuilder internal constructor() {
    private var autoUserSpecification: Output<Any>? = null

    private var command: Output<Any>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var extendedProperties: Output<Map<String, Any>>? = null

    private var folderPath: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var referenceObjects: Output<CustomActivityReferenceObjectArgs>? = null

    private var resourceLinkedService: Output<LinkedServiceReferenceArgs>? = null

    private var retentionTimeInDays: Output<Any>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double).
     */
    @JvmName("hndjrduatqixdcad")
    public suspend fun autoUserSpecification(`value`: Output<Any>) {
        this.autoUserSpecification = value
    }

    /**
     * @param value Command for custom activity Type: string (or Expression with resultType string).
     */
    @JvmName("fkkgoreavuvyvdry")
    public suspend fun command(`value`: Output<Any>) {
        this.command = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("woaabeyvguecqsoq")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("odbyoylonxucfogd")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("scluaeiwcjbxkxtr")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("amneqnoorsnfrdta")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
     */
    @JvmName("wsihjiwekptnknbs")
    public suspend fun extendedProperties(`value`: Output<Map<String, Any>>) {
        this.extendedProperties = value
    }

    /**
     * @param value Folder path for resource files Type: string (or Expression with resultType string).
     */
    @JvmName("ipfoaayxtlxcdqok")
    public suspend fun folderPath(`value`: Output<Any>) {
        this.folderPath = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("cnsddricytmylxrm")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("vvidyjhdeqcmcggm")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("pieenryvdbgpjcgu")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("lfecohfpfcjqhcph")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value Reference objects
     */
    @JvmName("towiophyhsqbmtws")
    public suspend fun referenceObjects(`value`: Output<CustomActivityReferenceObjectArgs>) {
        this.referenceObjects = value
    }

    /**
     * @param value Resource linked service reference.
     */
    @JvmName("oxqymmjyfsbbyaxs")
    public suspend fun resourceLinkedService(`value`: Output<LinkedServiceReferenceArgs>) {
        this.resourceLinkedService = value
    }

    /**
     * @param value The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double).
     */
    @JvmName("yulluoctbetgxjaq")
    public suspend fun retentionTimeInDays(`value`: Output<Any>) {
        this.retentionTimeInDays = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("cwhssnwhxpnijdmx")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Custom'.
     */
    @JvmName("eqwmnylchnfurorw")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("qfflatbatlsnelgy")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("xdvkginflipyndnh")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("ccfemsjyuswqlrfh")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Elevation level and scope for the user, default is nonadmin task. Type: string (or Expression with resultType double).
     */
    @JvmName("pybadhdowsmfjwdt")
    public suspend fun autoUserSpecification(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoUserSpecification = mapped
    }

    /**
     * @param value Command for custom activity Type: string (or Expression with resultType string).
     */
    @JvmName("teyxeiicafdcvshi")
    public suspend fun command(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.command = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("titjghvuwaxhbsdl")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("pnkaqlyxnmakrofc")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("inuebedpmydxtdan")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("yifsfyknkjtmslfe")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("dnenuiyvxncacyon")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("sumsqjsylibsaurg")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
     */
    @JvmName("oxmowmixmjpwisqr")
    public suspend fun extendedProperties(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param values User defined property bag. There is no restriction on the keys or values that can be used. The user specified custom activity has the full responsibility to consume and interpret the content defined.
     */
    @JvmName("dexihgbdxdtvlbwr")
    public fun extendedProperties(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.extendedProperties = mapped
    }

    /**
     * @param value Folder path for resource files Type: string (or Expression with resultType string).
     */
    @JvmName("vckmtolftqihoqdo")
    public suspend fun folderPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.folderPath = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("uxnrquleltkcdkhx")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("tlxsujrbtuogncrw")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("vitxvungpsjtfrus")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("odnpardbobijjgey")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("iqlbgockrbukqbwi")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("gobhfeauelrqgled")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("dmrgflqselyhbudv")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("epbrbkdpppeqfmkr")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value Reference objects
     */
    @JvmName("rhlhgffumblbydpy")
    public suspend fun referenceObjects(`value`: CustomActivityReferenceObjectArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.referenceObjects = mapped
    }

    /**
     * @param argument Reference objects
     */
    @JvmName("jwgkjggxmgymweda")
    public suspend
    fun referenceObjects(argument: suspend CustomActivityReferenceObjectArgsBuilder.() -> Unit) {
        val toBeMapped = CustomActivityReferenceObjectArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.referenceObjects = mapped
    }

    /**
     * @param value Resource linked service reference.
     */
    @JvmName("cxnscxqujbapbcrw")
    public suspend fun resourceLinkedService(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resourceLinkedService = mapped
    }

    /**
     * @param argument Resource linked service reference.
     */
    @JvmName("vuhqynjxtcplhpuk")
    public suspend
    fun resourceLinkedService(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.resourceLinkedService = mapped
    }

    /**
     * @param value The retention time for the files submitted for custom activity. Type: double (or Expression with resultType double).
     */
    @JvmName("fgscivajyheaeopb")
    public suspend fun retentionTimeInDays(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.retentionTimeInDays = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("eajmsrvmthruxkwv")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("cbpwpddpbfctdfoq")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("vnkxeeqkifcqdwvo")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Custom'.
     */
    @JvmName("mgqnimejdogrnnjb")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("fsmnvjcsouswqgep")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("fmkqxdslurdyqdbq")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("usbmfvustcyocfnp")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("joupwpjuwnravtfi")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("fnrodhnbybqdjtns")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): CustomActivityArgs = CustomActivityArgs(
        autoUserSpecification = autoUserSpecification,
        command = command ?: throw PulumiNullFieldException("command"),
        dependsOn = dependsOn,
        description = description,
        extendedProperties = extendedProperties,
        folderPath = folderPath,
        linkedServiceName = linkedServiceName,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        referenceObjects = referenceObjects,
        resourceLinkedService = resourceLinkedService,
        retentionTimeInDays = retentionTimeInDays,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
