@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DWCopyCommandDefaultValueArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Default value.
 * @property columnName Column name. Type: object (or Expression with resultType string).
 * @property defaultValue The default value of the column. Type: object (or Expression with resultType string).
 */
public data class DWCopyCommandDefaultValueArgs(
    public val columnName: Output<Any>? = null,
    public val defaultValue: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DWCopyCommandDefaultValueArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DWCopyCommandDefaultValueArgs =
        com.pulumi.azurenative.datafactory.inputs.DWCopyCommandDefaultValueArgs.builder()
            .columnName(columnName?.applyValue({ args0 -> args0 }))
            .defaultValue(defaultValue?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DWCopyCommandDefaultValueArgs].
 */
@PulumiTagMarker
public class DWCopyCommandDefaultValueArgsBuilder internal constructor() {
    private var columnName: Output<Any>? = null

    private var defaultValue: Output<Any>? = null

    /**
     * @param value Column name. Type: object (or Expression with resultType string).
     */
    @JvmName("jbepvamvsvktyabh")
    public suspend fun columnName(`value`: Output<Any>) {
        this.columnName = value
    }

    /**
     * @param value The default value of the column. Type: object (or Expression with resultType string).
     */
    @JvmName("qbsshilcdllippyl")
    public suspend fun defaultValue(`value`: Output<Any>) {
        this.defaultValue = value
    }

    /**
     * @param value Column name. Type: object (or Expression with resultType string).
     */
    @JvmName("ngvhlymegwselcht")
    public suspend fun columnName(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.columnName = mapped
    }

    /**
     * @param value The default value of the column. Type: object (or Expression with resultType string).
     */
    @JvmName("rymlbrtyxxfgkfjp")
    public suspend fun defaultValue(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.defaultValue = mapped
    }

    internal fun build(): DWCopyCommandDefaultValueArgs = DWCopyCommandDefaultValueArgs(
        columnName = columnName,
        defaultValue = defaultValue,
    )
}
