@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DatasetReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Dataset reference type.
 * @property parameters Arguments for dataset.
 * @property referenceName Reference dataset name.
 * @property type Dataset reference type.
 */
public data class DatasetReferenceArgs(
    public val parameters: Output<Map<String, Any>>? = null,
    public val referenceName: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DatasetReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DatasetReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.DatasetReferenceArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DatasetReferenceArgs].
 */
@PulumiTagMarker
public class DatasetReferenceArgsBuilder internal constructor() {
    private var parameters: Output<Map<String, Any>>? = null

    private var referenceName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Arguments for dataset.
     */
    @JvmName("kfwrdmqfmindgdrp")
    public suspend fun parameters(`value`: Output<Map<String, Any>>) {
        this.parameters = value
    }

    /**
     * @param value Reference dataset name.
     */
    @JvmName("nibikfftyrvjnqwi")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Dataset reference type.
     */
    @JvmName("wagbxpwqcwfhtchy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Arguments for dataset.
     */
    @JvmName("qihogeopnqnbitlw")
    public suspend fun parameters(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Arguments for dataset.
     */
    @JvmName("dkjdhpihqunbkyxs")
    public fun parameters(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Reference dataset name.
     */
    @JvmName("nxktlckgoctklooo")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Dataset reference type.
     */
    @JvmName("dqkscaguvgaduocx")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): DatasetReferenceArgs = DatasetReferenceArgs(
        parameters = parameters,
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
