@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.DeleteActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Delete activity.
 * @property dataset Delete activity dataset reference.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property enableLogging Whether to record detailed logs of delete-activity execution. Default value is false. Type: boolean (or Expression with resultType boolean).
 * @property linkedServiceName Linked service reference.
 * @property logStorageSettings Log storage settings customer need to provide when enableLogging is true.
 * @property maxConcurrentConnections The max concurrent connections to connect data source at the same time.
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property policy Activity policy.
 * @property recursive If true, files or sub-folders under current folder path will be deleted recursively. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property storeSettings Delete activity store settings.
 * @property type Type of activity.
 * Expected value is 'Delete'.
 * @property userProperties Activity user properties.
 */
public data class DeleteActivityArgs(
    public val dataset: Output<DatasetReferenceArgs>,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val enableLogging: Output<Any>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val logStorageSettings: Output<LogStorageSettingsArgs>? = null,
    public val maxConcurrentConnections: Output<Int>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val recursive: Output<Any>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val storeSettings: Output<Any>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.DeleteActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.DeleteActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.DeleteActivityArgs.builder()
            .dataset(dataset.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .enableLogging(enableLogging?.applyValue({ args0 -> args0 }))
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logStorageSettings(
                logStorageSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .recursive(recursive?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .storeSettings(storeSettings?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [DeleteActivityArgs].
 */
@PulumiTagMarker
public class DeleteActivityArgsBuilder internal constructor() {
    private var dataset: Output<DatasetReferenceArgs>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var enableLogging: Output<Any>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var logStorageSettings: Output<LogStorageSettingsArgs>? = null

    private var maxConcurrentConnections: Output<Int>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var recursive: Output<Any>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var storeSettings: Output<Any>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value Delete activity dataset reference.
     */
    @JvmName("inbyhcoviyyfcbii")
    public suspend fun dataset(`value`: Output<DatasetReferenceArgs>) {
        this.dataset = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("jfsfdqkfahwoksxm")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("vbvbnndugbvtsvby")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("gsghignsoixvjyri")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("obdrudugyiwhqhxn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Whether to record detailed logs of delete-activity execution. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("rcsqwgyhabcrfrpl")
    public suspend fun enableLogging(`value`: Output<Any>) {
        this.enableLogging = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("brbikpelobpipjut")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value Log storage settings customer need to provide when enableLogging is true.
     */
    @JvmName("xrglomtgmexidkyf")
    public suspend fun logStorageSettings(`value`: Output<LogStorageSettingsArgs>) {
        this.logStorageSettings = value
    }

    /**
     * @param value The max concurrent connections to connect data source at the same time.
     */
    @JvmName("hvflvwoocojwdlxy")
    public suspend fun maxConcurrentConnections(`value`: Output<Int>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("qlxuqkhfkmwkdxit")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("idkyuhyqkcpvrtcy")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("nmeidxacwqqpmqlk")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value If true, files or sub-folders under current folder path will be deleted recursively. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("ghwquvtyonksobhg")
    public suspend fun recursive(`value`: Output<Any>) {
        this.recursive = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("myhqjfqsdkhjumjv")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Delete activity store settings.
     */
    @JvmName("agnxwqiqjlupwdlj")
    public suspend fun storeSettings(`value`: Output<Any>) {
        this.storeSettings = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Delete'.
     */
    @JvmName("ekeutndkwqfhyija")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("qpucbfqagkaadeps")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("ogiwicpkkmqicydn")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("mjaqmnvfaamtcxdb")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value Delete activity dataset reference.
     */
    @JvmName("sewkqklxprcsbofr")
    public suspend fun dataset(`value`: DatasetReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dataset = mapped
    }

    /**
     * @param argument Delete activity dataset reference.
     */
    @JvmName("xhxectauniworjmm")
    public suspend fun dataset(argument: suspend DatasetReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = DatasetReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.dataset = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("bjfllanemlaiwquj")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("kgebkwtmgmdnyusk")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("yhivuapoqycgihnx")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("bhcaqmxbudngosow")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("iwmbejqbgpbdlntp")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("hgpnbqkpugamjpbd")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Whether to record detailed logs of delete-activity execution. Default value is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("lyhuajylsfdwawvr")
    public suspend fun enableLogging(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableLogging = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("dfbpilfdwetruvvf")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("ydwcfqevqwnwdxbb")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value Log storage settings customer need to provide when enableLogging is true.
     */
    @JvmName("tkckybfpxuxrblgt")
    public suspend fun logStorageSettings(`value`: LogStorageSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logStorageSettings = mapped
    }

    /**
     * @param argument Log storage settings customer need to provide when enableLogging is true.
     */
    @JvmName("dukoulhdidppbwws")
    public suspend
    fun logStorageSettings(argument: suspend LogStorageSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = LogStorageSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logStorageSettings = mapped
    }

    /**
     * @param value The max concurrent connections to connect data source at the same time.
     */
    @JvmName("vkqhltacrljmbmhu")
    public suspend fun maxConcurrentConnections(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("krwadkftcelbefev")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("ondrtyuorohshcww")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("hejfqqnigwiwpill")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("dmtxmljxtewktsmn")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("onjhmmwqhvfnanfh")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("otgdfufaoldknyeg")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value If true, files or sub-folders under current folder path will be deleted recursively. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("gvmnahgqcpnwuvwh")
    public suspend fun recursive(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.recursive = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("rrpqhufbureqxlkw")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("iydptjmhotyjqaua")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("gyomqmpvbjuggvtx")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Delete activity store settings.
     */
    @JvmName("ydpatykgqgdewafk")
    public suspend fun storeSettings(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storeSettings = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'Delete'.
     */
    @JvmName("tuvxhvvlawjitqkr")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("denschkdhevlnays")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("dtbieeomnskwonmm")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("jdcwfxsvclufjcso")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("igvvktojoqihcufx")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("lcsfitipnfedddnw")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): DeleteActivityArgs = DeleteActivityArgs(
        dataset = dataset ?: throw PulumiNullFieldException("dataset"),
        dependsOn = dependsOn,
        description = description,
        enableLogging = enableLogging,
        linkedServiceName = linkedServiceName,
        logStorageSettings = logStorageSettings,
        maxConcurrentConnections = maxConcurrentConnections,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        policy = policy,
        recursive = recursive,
        state = state,
        storeSettings = storeSettings,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
