@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ExecutePipelineActivityPolicyArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Execution policy for an execute pipeline activity.
 * @property secureInput When set to true, Input from activity is considered as secure and will not be logged to monitoring.
 */
public data class ExecutePipelineActivityPolicyArgs(
    public val secureInput: Output<Boolean>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ExecutePipelineActivityPolicyArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ExecutePipelineActivityPolicyArgs =
        com.pulumi.azurenative.datafactory.inputs.ExecutePipelineActivityPolicyArgs.builder()
            .secureInput(secureInput?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ExecutePipelineActivityPolicyArgs].
 */
@PulumiTagMarker
public class ExecutePipelineActivityPolicyArgsBuilder internal constructor() {
    private var secureInput: Output<Boolean>? = null

    /**
     * @param value When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("ojwfvmwrskxkylpk")
    public suspend fun secureInput(`value`: Output<Boolean>) {
        this.secureInput = value
    }

    /**
     * @param value When set to true, Input from activity is considered as secure and will not be logged to monitoring.
     */
    @JvmName("pmatqambvlaoraul")
    public suspend fun secureInput(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.secureInput = mapped
    }

    internal fun build(): ExecutePipelineActivityPolicyArgs = ExecutePipelineActivityPolicyArgs(
        secureInput = secureInput,
    )
}
