@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ExecuteSSISPackageActivityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityOnInactiveMarkAs
import com.pulumi.azurenative.datafactory.kotlin.enums.ActivityState
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Execute SSIS package activity.
 * @property connectVia The integration runtime reference.
 * @property dependsOn Activity depends on condition.
 * @property description Activity description.
 * @property environmentPath The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
 * @property executionCredential The package execution credential.
 * @property linkedServiceName Linked service reference.
 * @property logLocation SSIS package execution log location.
 * @property loggingLevel The logging level of SSIS package execution. Type: string (or Expression with resultType string).
 * @property name Activity name.
 * @property onInactiveMarkAs Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
 * @property packageConnectionManagers The package level connection managers to execute the SSIS package.
 * @property packageLocation SSIS package location.
 * @property packageParameters The package level parameters to execute the SSIS package.
 * @property policy Activity policy.
 * @property projectConnectionManagers The project level connection managers to execute the SSIS package.
 * @property projectParameters The project level parameters to execute the SSIS package.
 * @property propertyOverrides The property overrides to execute the SSIS package.
 * @property runtime Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
 * @property state Activity state. This is an optional property and if not provided, the state will be Active by default.
 * @property type Type of activity.
 * Expected value is 'ExecuteSSISPackage'.
 * @property userProperties Activity user properties.
 */
public data class ExecuteSSISPackageActivityArgs(
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>,
    public val dependsOn: Output<List<ActivityDependencyArgs>>? = null,
    public val description: Output<String>? = null,
    public val environmentPath: Output<Any>? = null,
    public val executionCredential: Output<SSISExecutionCredentialArgs>? = null,
    public val linkedServiceName: Output<LinkedServiceReferenceArgs>? = null,
    public val logLocation: Output<SSISLogLocationArgs>? = null,
    public val loggingLevel: Output<Any>? = null,
    public val name: Output<String>,
    public val onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null,
    public val packageConnectionManagers:
    Output<Map<String, Map<String, SSISExecutionParameterArgs>>>? = null,
    public val packageLocation: Output<SSISPackageLocationArgs>,
    public val packageParameters: Output<Map<String, SSISExecutionParameterArgs>>? = null,
    public val policy: Output<ActivityPolicyArgs>? = null,
    public val projectConnectionManagers:
    Output<Map<String, Map<String, SSISExecutionParameterArgs>>>? = null,
    public val projectParameters: Output<Map<String, SSISExecutionParameterArgs>>? = null,
    public val propertyOverrides: Output<Map<String, SSISPropertyOverrideArgs>>? = null,
    public val runtime: Output<Any>? = null,
    public val state: Output<Either<String, ActivityState>>? = null,
    public val type: Output<String>,
    public val userProperties: Output<List<UserPropertyArgs>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ExecuteSSISPackageActivityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ExecuteSSISPackageActivityArgs =
        com.pulumi.azurenative.datafactory.inputs.ExecuteSSISPackageActivityArgs.builder()
            .connectVia(connectVia.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .dependsOn(
                dependsOn?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .environmentPath(environmentPath?.applyValue({ args0 -> args0 }))
            .executionCredential(
                executionCredential?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .linkedServiceName(linkedServiceName?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .logLocation(logLocation?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .loggingLevel(loggingLevel?.applyValue({ args0 -> args0 }))
            .name(name.applyValue({ args0 -> args0 }))
            .onInactiveMarkAs(
                onInactiveMarkAs?.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .packageConnectionManagers(
                packageConnectionManagers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0.key.to(
                                    args0.value.let({ args0 ->
                                        args0.toJava()
                                    }),
                                )
                            }).toMap(),
                        )
                    }).toMap()
                }),
            )
            .packageLocation(packageLocation.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .packageParameters(
                packageParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .policy(policy?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .projectConnectionManagers(
                projectConnectionManagers?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(
                            args0.value.map({ args0 ->
                                args0.key.to(
                                    args0.value.let({ args0 ->
                                        args0.toJava()
                                    }),
                                )
                            }).toMap(),
                        )
                    }).toMap()
                }),
            )
            .projectParameters(
                projectParameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .propertyOverrides(
                propertyOverrides?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .runtime(runtime?.applyValue({ args0 -> args0 }))
            .state(
                state?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .type(type.applyValue({ args0 -> args0 }))
            .userProperties(
                userProperties?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [ExecuteSSISPackageActivityArgs].
 */
@PulumiTagMarker
public class ExecuteSSISPackageActivityArgsBuilder internal constructor() {
    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var dependsOn: Output<List<ActivityDependencyArgs>>? = null

    private var description: Output<String>? = null

    private var environmentPath: Output<Any>? = null

    private var executionCredential: Output<SSISExecutionCredentialArgs>? = null

    private var linkedServiceName: Output<LinkedServiceReferenceArgs>? = null

    private var logLocation: Output<SSISLogLocationArgs>? = null

    private var loggingLevel: Output<Any>? = null

    private var name: Output<String>? = null

    private var onInactiveMarkAs: Output<Either<String, ActivityOnInactiveMarkAs>>? = null

    private var packageConnectionManagers:
        Output<Map<String, Map<String, SSISExecutionParameterArgs>>>? = null

    private var packageLocation: Output<SSISPackageLocationArgs>? = null

    private var packageParameters: Output<Map<String, SSISExecutionParameterArgs>>? = null

    private var policy: Output<ActivityPolicyArgs>? = null

    private var projectConnectionManagers:
        Output<Map<String, Map<String, SSISExecutionParameterArgs>>>? = null

    private var projectParameters: Output<Map<String, SSISExecutionParameterArgs>>? = null

    private var propertyOverrides: Output<Map<String, SSISPropertyOverrideArgs>>? = null

    private var runtime: Output<Any>? = null

    private var state: Output<Either<String, ActivityState>>? = null

    private var type: Output<String>? = null

    private var userProperties: Output<List<UserPropertyArgs>>? = null

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("qcoytsdtmeexxnch")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("xpcqbkrhxjtchsgk")
    public suspend fun dependsOn(`value`: Output<List<ActivityDependencyArgs>>) {
        this.dependsOn = value
    }

    @JvmName("hpswydedhljcgiog")
    public suspend fun dependsOn(vararg values: Output<ActivityDependencyArgs>) {
        this.dependsOn = Output.all(values.asList())
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("ojhvokkqmxexhfyq")
    public suspend fun dependsOn(values: List<Output<ActivityDependencyArgs>>) {
        this.dependsOn = Output.all(values)
    }

    /**
     * @param value Activity description.
     */
    @JvmName("fmawvuqqijmlgmkq")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
     */
    @JvmName("enajwielndkwecod")
    public suspend fun environmentPath(`value`: Output<Any>) {
        this.environmentPath = value
    }

    /**
     * @param value The package execution credential.
     */
    @JvmName("chpqqiscselewisq")
    public suspend fun executionCredential(`value`: Output<SSISExecutionCredentialArgs>) {
        this.executionCredential = value
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("sncpldktyqyhmimv")
    public suspend fun linkedServiceName(`value`: Output<LinkedServiceReferenceArgs>) {
        this.linkedServiceName = value
    }

    /**
     * @param value SSIS package execution log location.
     */
    @JvmName("nwicjidiwetkggev")
    public suspend fun logLocation(`value`: Output<SSISLogLocationArgs>) {
        this.logLocation = value
    }

    /**
     * @param value The logging level of SSIS package execution. Type: string (or Expression with resultType string).
     */
    @JvmName("jwgtqawmwfyfbqjy")
    public suspend fun loggingLevel(`value`: Output<Any>) {
        this.loggingLevel = value
    }

    /**
     * @param value Activity name.
     */
    @JvmName("pyeefyvhiknrxlvi")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("uhhfqnihcbvpmmay")
    public suspend fun onInactiveMarkAs(`value`: Output<Either<String, ActivityOnInactiveMarkAs>>) {
        this.onInactiveMarkAs = value
    }

    /**
     * @param value The package level connection managers to execute the SSIS package.
     */
    @JvmName("paqvthwfurcbhxyh")
    public suspend
    fun packageConnectionManagers(`value`: Output<Map<String, Map<String, SSISExecutionParameterArgs>>>) {
        this.packageConnectionManagers = value
    }

    /**
     * @param value SSIS package location.
     */
    @JvmName("khemudqqvwsslfia")
    public suspend fun packageLocation(`value`: Output<SSISPackageLocationArgs>) {
        this.packageLocation = value
    }

    /**
     * @param value The package level parameters to execute the SSIS package.
     */
    @JvmName("qclhrgciduacajky")
    public suspend fun packageParameters(`value`: Output<Map<String, SSISExecutionParameterArgs>>) {
        this.packageParameters = value
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("amhkvrduoxaemolh")
    public suspend fun policy(`value`: Output<ActivityPolicyArgs>) {
        this.policy = value
    }

    /**
     * @param value The project level connection managers to execute the SSIS package.
     */
    @JvmName("afwstqnrhtsnbixc")
    public suspend
    fun projectConnectionManagers(`value`: Output<Map<String, Map<String, SSISExecutionParameterArgs>>>) {
        this.projectConnectionManagers = value
    }

    /**
     * @param value The project level parameters to execute the SSIS package.
     */
    @JvmName("kcdhmjfqgqayfqon")
    public suspend fun projectParameters(`value`: Output<Map<String, SSISExecutionParameterArgs>>) {
        this.projectParameters = value
    }

    /**
     * @param value The property overrides to execute the SSIS package.
     */
    @JvmName("omjlewjliayxqfki")
    public suspend fun propertyOverrides(`value`: Output<Map<String, SSISPropertyOverrideArgs>>) {
        this.propertyOverrides = value
    }

    /**
     * @param value Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
     */
    @JvmName("ulucfolssikwvqwc")
    public suspend fun runtime(`value`: Output<Any>) {
        this.runtime = value
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("jrdfhsqgwifnonrn")
    public suspend fun state(`value`: Output<Either<String, ActivityState>>) {
        this.state = value
    }

    /**
     * @param value Type of activity.
     * Expected value is 'ExecuteSSISPackage'.
     */
    @JvmName("pdjjxygkcjxnckgu")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("waothtncfumhmvtk")
    public suspend fun userProperties(`value`: Output<List<UserPropertyArgs>>) {
        this.userProperties = value
    }

    @JvmName("qwouyyiyxnxbetdh")
    public suspend fun userProperties(vararg values: Output<UserPropertyArgs>) {
        this.userProperties = Output.all(values.asList())
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("knlnimhtgarsgddt")
    public suspend fun userProperties(values: List<Output<UserPropertyArgs>>) {
        this.userProperties = Output.all(values)
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("wfklwfmlsqovkxvs")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("tijlckntcultfhpi")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Activity depends on condition.
     */
    @JvmName("inootxjhydhymonm")
    public suspend fun dependsOn(`value`: List<ActivityDependencyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("iqwbgxmtqpgloyda")
    public suspend fun dependsOn(argument: List<suspend ActivityDependencyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("lrdjqmvgieewlbxy")
    public suspend fun dependsOn(vararg argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ActivityDependencyArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param argument Activity depends on condition.
     */
    @JvmName("sfuvfwiitqshsdoq")
    public suspend fun dependsOn(argument: suspend ActivityDependencyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(ActivityDependencyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.dependsOn = mapped
    }

    /**
     * @param values Activity depends on condition.
     */
    @JvmName("mmfwqqilvpyuwblo")
    public suspend fun dependsOn(vararg values: ActivityDependencyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.dependsOn = mapped
    }

    /**
     * @param value Activity description.
     */
    @JvmName("vfntlgjfnsgprqbe")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The environment path to execute the SSIS package. Type: string (or Expression with resultType string).
     */
    @JvmName("baerhoormvcmlxye")
    public suspend fun environmentPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.environmentPath = mapped
    }

    /**
     * @param value The package execution credential.
     */
    @JvmName("vtxoipusgsokrhkq")
    public suspend fun executionCredential(`value`: SSISExecutionCredentialArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.executionCredential = mapped
    }

    /**
     * @param argument The package execution credential.
     */
    @JvmName("finbvyinuqcvqlpv")
    public suspend
    fun executionCredential(argument: suspend SSISExecutionCredentialArgsBuilder.() -> Unit) {
        val toBeMapped = SSISExecutionCredentialArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.executionCredential = mapped
    }

    /**
     * @param value Linked service reference.
     */
    @JvmName("hkmmrqwyrwbfusio")
    public suspend fun linkedServiceName(`value`: LinkedServiceReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.linkedServiceName = mapped
    }

    /**
     * @param argument Linked service reference.
     */
    @JvmName("iqyumhcsotfnblyj")
    public suspend
    fun linkedServiceName(argument: suspend LinkedServiceReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = LinkedServiceReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.linkedServiceName = mapped
    }

    /**
     * @param value SSIS package execution log location.
     */
    @JvmName("arpvvvtctgeycpuj")
    public suspend fun logLocation(`value`: SSISLogLocationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.logLocation = mapped
    }

    /**
     * @param argument SSIS package execution log location.
     */
    @JvmName("mfyajltpjpjpjegx")
    public suspend fun logLocation(argument: suspend SSISLogLocationArgsBuilder.() -> Unit) {
        val toBeMapped = SSISLogLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.logLocation = mapped
    }

    /**
     * @param value The logging level of SSIS package execution. Type: string (or Expression with resultType string).
     */
    @JvmName("rorsnylwxiylkktr")
    public suspend fun loggingLevel(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.loggingLevel = mapped
    }

    /**
     * @param value Activity name.
     */
    @JvmName("kuqkkwaacxsilivv")
    public suspend fun name(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("ubufhunqpiqmprjk")
    public suspend fun onInactiveMarkAs(`value`: Either<String, ActivityOnInactiveMarkAs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("nbrntntetqpubgio")
    public fun onInactiveMarkAs(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value Status result of the activity when the state is set to Inactive. This is an optional property and if not provided when the activity is inactive, the status will be Succeeded by default.
     */
    @JvmName("geqhwswlvdebbxxr")
    public fun onInactiveMarkAs(`value`: ActivityOnInactiveMarkAs) {
        val toBeMapped = Either.ofRight<String, ActivityOnInactiveMarkAs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.onInactiveMarkAs = mapped
    }

    /**
     * @param value The package level connection managers to execute the SSIS package.
     */
    @JvmName("gcbueaulnwlrdmsr")
    public suspend
    fun packageConnectionManagers(`value`: Map<String, Map<String, SSISExecutionParameterArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageConnectionManagers = mapped
    }

    /**
     * @param values The package level connection managers to execute the SSIS package.
     */
    @JvmName("mfsasbhiipshmqtp")
    public fun packageConnectionManagers(
        vararg
        values: Pair<String, Map<String, SSISExecutionParameterArgs>>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageConnectionManagers = mapped
    }

    /**
     * @param value SSIS package location.
     */
    @JvmName("rvvjhrvuhddperyq")
    public suspend fun packageLocation(`value`: SSISPackageLocationArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageLocation = mapped
    }

    /**
     * @param argument SSIS package location.
     */
    @JvmName("nergwtwqmglsyrjk")
    public suspend fun packageLocation(argument: suspend SSISPackageLocationArgsBuilder.() -> Unit) {
        val toBeMapped = SSISPackageLocationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.packageLocation = mapped
    }

    /**
     * @param value The package level parameters to execute the SSIS package.
     */
    @JvmName("yqrkrgutaaiqlood")
    public suspend fun packageParameters(`value`: Map<String, SSISExecutionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageParameters = mapped
    }

    /**
     * @param argument The package level parameters to execute the SSIS package.
     */
    @JvmName("hsdiwpgbxnaenjad")
    public suspend fun packageParameters(
        vararg
        argument: Pair<String, suspend SSISExecutionParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                SSISExecutionParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.packageParameters = mapped
    }

    /**
     * @param values The package level parameters to execute the SSIS package.
     */
    @JvmName("ahklhianqpokdhwe")
    public fun packageParameters(vararg values: Pair<String, SSISExecutionParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageParameters = mapped
    }

    /**
     * @param value Activity policy.
     */
    @JvmName("ugnogtpqvsyiocnj")
    public suspend fun policy(`value`: ActivityPolicyArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.policy = mapped
    }

    /**
     * @param argument Activity policy.
     */
    @JvmName("lwvehljgfuftokre")
    public suspend fun policy(argument: suspend ActivityPolicyArgsBuilder.() -> Unit) {
        val toBeMapped = ActivityPolicyArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.policy = mapped
    }

    /**
     * @param value The project level connection managers to execute the SSIS package.
     */
    @JvmName("jnpljbybreqqpiyi")
    public suspend
    fun projectConnectionManagers(`value`: Map<String, Map<String, SSISExecutionParameterArgs>>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectConnectionManagers = mapped
    }

    /**
     * @param values The project level connection managers to execute the SSIS package.
     */
    @JvmName("hsflidqkuwdstpbs")
    public fun projectConnectionManagers(
        vararg
        values: Pair<String, Map<String, SSISExecutionParameterArgs>>,
    ) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectConnectionManagers = mapped
    }

    /**
     * @param value The project level parameters to execute the SSIS package.
     */
    @JvmName("svruvagufrwtijpx")
    public suspend fun projectParameters(`value`: Map<String, SSISExecutionParameterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.projectParameters = mapped
    }

    /**
     * @param argument The project level parameters to execute the SSIS package.
     */
    @JvmName("huvxrltmvrjcwvxm")
    public suspend fun projectParameters(
        vararg
        argument: Pair<String, suspend SSISExecutionParameterArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                SSISExecutionParameterArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.projectParameters = mapped
    }

    /**
     * @param values The project level parameters to execute the SSIS package.
     */
    @JvmName("rimdxkcboyqinjwe")
    public fun projectParameters(vararg values: Pair<String, SSISExecutionParameterArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectParameters = mapped
    }

    /**
     * @param value The property overrides to execute the SSIS package.
     */
    @JvmName("suddfwagsmxgqicv")
    public suspend fun propertyOverrides(`value`: Map<String, SSISPropertyOverrideArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.propertyOverrides = mapped
    }

    /**
     * @param argument The property overrides to execute the SSIS package.
     */
    @JvmName("afpqpctcmfibirjh")
    public suspend fun propertyOverrides(
        vararg
        argument: Pair<String, suspend SSISPropertyOverrideArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                SSISPropertyOverrideArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.propertyOverrides = mapped
    }

    /**
     * @param values The property overrides to execute the SSIS package.
     */
    @JvmName("imuyioipjgbfyhwm")
    public fun propertyOverrides(vararg values: Pair<String, SSISPropertyOverrideArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.propertyOverrides = mapped
    }

    /**
     * @param value Specifies the runtime to execute SSIS package. The value should be "x86" or "x64". Type: string (or Expression with resultType string).
     */
    @JvmName("lccvlsdjsncpbaao")
    public suspend fun runtime(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("xajghvjbvuiwutho")
    public suspend fun state(`value`: Either<String, ActivityState>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("ionglaqedormwyin")
    public fun state(`value`: String) {
        val toBeMapped = Either.ofLeft<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Activity state. This is an optional property and if not provided, the state will be Active by default.
     */
    @JvmName("vllultkgnsbopwur")
    public fun state(`value`: ActivityState) {
        val toBeMapped = Either.ofRight<String, ActivityState>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.state = mapped
    }

    /**
     * @param value Type of activity.
     * Expected value is 'ExecuteSSISPackage'.
     */
    @JvmName("yrthyxghpbvhyetm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Activity user properties.
     */
    @JvmName("bbyananqfllobrno")
    public suspend fun userProperties(`value`: List<UserPropertyArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("dhbvkkqbkqomqylo")
    public suspend fun userProperties(argument: List<suspend UserPropertyArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("mxlxmepbxihnkkax")
    public suspend fun userProperties(vararg argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            UserPropertyArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param argument Activity user properties.
     */
    @JvmName("cjfusodjlbnvrrua")
    public suspend fun userProperties(argument: suspend UserPropertyArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(UserPropertyArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userProperties = mapped
    }

    /**
     * @param values Activity user properties.
     */
    @JvmName("gpxpbwkmruekmdnk")
    public suspend fun userProperties(vararg values: UserPropertyArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userProperties = mapped
    }

    internal fun build(): ExecuteSSISPackageActivityArgs = ExecuteSSISPackageActivityArgs(
        connectVia = connectVia ?: throw PulumiNullFieldException("connectVia"),
        dependsOn = dependsOn,
        description = description,
        environmentPath = environmentPath,
        executionCredential = executionCredential,
        linkedServiceName = linkedServiceName,
        logLocation = logLocation,
        loggingLevel = loggingLevel,
        name = name ?: throw PulumiNullFieldException("name"),
        onInactiveMarkAs = onInactiveMarkAs,
        packageConnectionManagers = packageConnectionManagers,
        packageLocation = packageLocation ?: throw PulumiNullFieldException("packageLocation"),
        packageParameters = packageParameters,
        policy = policy,
        projectConnectionManagers = projectConnectionManagers,
        projectParameters = projectParameters,
        propertyOverrides = propertyOverrides,
        runtime = runtime,
        state = state,
        type = type ?: throw PulumiNullFieldException("type"),
        userProperties = userProperties,
    )
}
