@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.FactoryGitHubConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Factory's GitHub repo information.
 * @property accountName Account name.
 * @property clientId GitHub bring your own app client id.
 * @property clientSecret GitHub bring your own app client secret information.
 * @property collaborationBranch Collaboration branch.
 * @property disablePublish Disable manual publish operation in ADF studio to favor automated publish.
 * @property hostName GitHub Enterprise host name. For example: `https://github.mydomain.com`
 * @property lastCommitId Last commit id.
 * @property repositoryName Repository name.
 * @property rootFolder Root folder.
 * @property type Type of repo configuration.
 * Expected value is 'FactoryGitHubConfiguration'.
 */
public data class FactoryGitHubConfigurationArgs(
    public val accountName: Output<String>,
    public val clientId: Output<String>? = null,
    public val clientSecret: Output<GitHubClientSecretArgs>? = null,
    public val collaborationBranch: Output<String>,
    public val disablePublish: Output<Boolean>? = null,
    public val hostName: Output<String>? = null,
    public val lastCommitId: Output<String>? = null,
    public val repositoryName: Output<String>,
    public val rootFolder: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.FactoryGitHubConfigurationArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.FactoryGitHubConfigurationArgs =
        com.pulumi.azurenative.datafactory.inputs.FactoryGitHubConfigurationArgs.builder()
            .accountName(accountName.applyValue({ args0 -> args0 }))
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(clientSecret?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .collaborationBranch(collaborationBranch.applyValue({ args0 -> args0 }))
            .disablePublish(disablePublish?.applyValue({ args0 -> args0 }))
            .hostName(hostName?.applyValue({ args0 -> args0 }))
            .lastCommitId(lastCommitId?.applyValue({ args0 -> args0 }))
            .repositoryName(repositoryName.applyValue({ args0 -> args0 }))
            .rootFolder(rootFolder.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FactoryGitHubConfigurationArgs].
 */
@PulumiTagMarker
public class FactoryGitHubConfigurationArgsBuilder internal constructor() {
    private var accountName: Output<String>? = null

    private var clientId: Output<String>? = null

    private var clientSecret: Output<GitHubClientSecretArgs>? = null

    private var collaborationBranch: Output<String>? = null

    private var disablePublish: Output<Boolean>? = null

    private var hostName: Output<String>? = null

    private var lastCommitId: Output<String>? = null

    private var repositoryName: Output<String>? = null

    private var rootFolder: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Account name.
     */
    @JvmName("smhaqvtqfjmqoemq")
    public suspend fun accountName(`value`: Output<String>) {
        this.accountName = value
    }

    /**
     * @param value GitHub bring your own app client id.
     */
    @JvmName("llomxubqvllyjdpq")
    public suspend fun clientId(`value`: Output<String>) {
        this.clientId = value
    }

    /**
     * @param value GitHub bring your own app client secret information.
     */
    @JvmName("swknkpfaonkcchko")
    public suspend fun clientSecret(`value`: Output<GitHubClientSecretArgs>) {
        this.clientSecret = value
    }

    /**
     * @param value Collaboration branch.
     */
    @JvmName("qikudbkqguelcjnm")
    public suspend fun collaborationBranch(`value`: Output<String>) {
        this.collaborationBranch = value
    }

    /**
     * @param value Disable manual publish operation in ADF studio to favor automated publish.
     */
    @JvmName("mrykquxptgjhwvse")
    public suspend fun disablePublish(`value`: Output<Boolean>) {
        this.disablePublish = value
    }

    /**
     * @param value GitHub Enterprise host name. For example: `https://github.mydomain.com`
     */
    @JvmName("jkmyvfladiworsfh")
    public suspend fun hostName(`value`: Output<String>) {
        this.hostName = value
    }

    /**
     * @param value Last commit id.
     */
    @JvmName("mimcwrkywuwudjwi")
    public suspend fun lastCommitId(`value`: Output<String>) {
        this.lastCommitId = value
    }

    /**
     * @param value Repository name.
     */
    @JvmName("evfabjnueuibuvda")
    public suspend fun repositoryName(`value`: Output<String>) {
        this.repositoryName = value
    }

    /**
     * @param value Root folder.
     */
    @JvmName("mhiathvflnsinjxd")
    public suspend fun rootFolder(`value`: Output<String>) {
        this.rootFolder = value
    }

    /**
     * @param value Type of repo configuration.
     * Expected value is 'FactoryGitHubConfiguration'.
     */
    @JvmName("vfnqkobfulniajok")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Account name.
     */
    @JvmName("ijqhkeqummkjjpbk")
    public suspend fun accountName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accountName = mapped
    }

    /**
     * @param value GitHub bring your own app client id.
     */
    @JvmName("tbaknpscpeeomneh")
    public suspend fun clientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value GitHub bring your own app client secret information.
     */
    @JvmName("naidwqasnosukffm")
    public suspend fun clientSecret(`value`: GitHubClientSecretArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param argument GitHub bring your own app client secret information.
     */
    @JvmName("hklsnmuenuglarxu")
    public suspend fun clientSecret(argument: suspend GitHubClientSecretArgsBuilder.() -> Unit) {
        val toBeMapped = GitHubClientSecretArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.clientSecret = mapped
    }

    /**
     * @param value Collaboration branch.
     */
    @JvmName("dvjkbnvbqwjojaef")
    public suspend fun collaborationBranch(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.collaborationBranch = mapped
    }

    /**
     * @param value Disable manual publish operation in ADF studio to favor automated publish.
     */
    @JvmName("dugaoditnggoufcc")
    public suspend fun disablePublish(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disablePublish = mapped
    }

    /**
     * @param value GitHub Enterprise host name. For example: `https://github.mydomain.com`
     */
    @JvmName("tbxxxhtdkirpbcxh")
    public suspend fun hostName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.hostName = mapped
    }

    /**
     * @param value Last commit id.
     */
    @JvmName("vtrkiatleobkevqx")
    public suspend fun lastCommitId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastCommitId = mapped
    }

    /**
     * @param value Repository name.
     */
    @JvmName("spnvlijiesedmlit")
    public suspend fun repositoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryName = mapped
    }

    /**
     * @param value Root folder.
     */
    @JvmName("tphcielldcplpkkb")
    public suspend fun rootFolder(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.rootFolder = mapped
    }

    /**
     * @param value Type of repo configuration.
     * Expected value is 'FactoryGitHubConfiguration'.
     */
    @JvmName("arynqakjwpucqmnv")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): FactoryGitHubConfigurationArgs = FactoryGitHubConfigurationArgs(
        accountName = accountName ?: throw PulumiNullFieldException("accountName"),
        clientId = clientId,
        clientSecret = clientSecret,
        collaborationBranch = collaborationBranch ?: throw PulumiNullFieldException("collaborationBranch"),
        disablePublish = disablePublish,
        hostName = hostName,
        lastCommitId = lastCommitId,
        repositoryName = repositoryName ?: throw PulumiNullFieldException("repositoryName"),
        rootFolder = rootFolder ?: throw PulumiNullFieldException("rootFolder"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
