@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.FactoryIdentityArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.FactoryIdentityType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Identity properties of the factory resource.
 * @property type The identity type.
 * @property userAssignedIdentities List of user assigned identities for the factory.
 */
public data class FactoryIdentityArgs(
    public val type: Output<Either<String, FactoryIdentityType>>,
    public val userAssignedIdentities: Output<Map<String, Any>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.FactoryIdentityArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.FactoryIdentityArgs =
        com.pulumi.azurenative.datafactory.inputs.FactoryIdentityArgs.builder()
            .type(
                type.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .userAssignedIdentities(
                userAssignedIdentities?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [FactoryIdentityArgs].
 */
@PulumiTagMarker
public class FactoryIdentityArgsBuilder internal constructor() {
    private var type: Output<Either<String, FactoryIdentityType>>? = null

    private var userAssignedIdentities: Output<Map<String, Any>>? = null

    /**
     * @param value The identity type.
     */
    @JvmName("taowyqnskyqmrssr")
    public suspend fun type(`value`: Output<Either<String, FactoryIdentityType>>) {
        this.type = value
    }

    /**
     * @param value List of user assigned identities for the factory.
     */
    @JvmName("lbqggwfyxwsdobrf")
    public suspend fun userAssignedIdentities(`value`: Output<Map<String, Any>>) {
        this.userAssignedIdentities = value
    }

    /**
     * @param value The identity type.
     */
    @JvmName("ugylukcnmfxttyox")
    public suspend fun type(`value`: Either<String, FactoryIdentityType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("ktcqpxxjhraiqwei")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, FactoryIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value The identity type.
     */
    @JvmName("kureeyddlutfmklx")
    public fun type(`value`: FactoryIdentityType) {
        val toBeMapped = Either.ofRight<String, FactoryIdentityType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value List of user assigned identities for the factory.
     */
    @JvmName("ipihhahfbnntdlcj")
    public suspend fun userAssignedIdentities(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    /**
     * @param values List of user assigned identities for the factory.
     */
    @JvmName("pxkorxrielmwovdi")
    public fun userAssignedIdentities(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userAssignedIdentities = mapped
    }

    internal fun build(): FactoryIdentityArgs = FactoryIdentityArgs(
        type = type ?: throw PulumiNullFieldException("type"),
        userAssignedIdentities = userAssignedIdentities,
    )
}
