@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetFactoryGitHubAccessTokenPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property gitHubAccessCode GitHub access code.
 * @property gitHubAccessTokenBaseUrl GitHub access token base URL.
 * @property gitHubClientId GitHub application client ID.
 * @property gitHubClientSecret GitHub bring your own app client secret information.
 * @property resourceGroupName The resource group name.
 */
public data class GetFactoryGitHubAccessTokenPlainArgs(
    public val factoryName: String,
    public val gitHubAccessCode: String,
    public val gitHubAccessTokenBaseUrl: String,
    public val gitHubClientId: String? = null,
    public val gitHubClientSecret: GitHubClientSecret? = null,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetFactoryGitHubAccessTokenPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.GetFactoryGitHubAccessTokenPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetFactoryGitHubAccessTokenPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .gitHubAccessCode(gitHubAccessCode.let({ args0 -> args0 }))
            .gitHubAccessTokenBaseUrl(gitHubAccessTokenBaseUrl.let({ args0 -> args0 }))
            .gitHubClientId(gitHubClientId?.let({ args0 -> args0 }))
            .gitHubClientSecret(gitHubClientSecret?.let({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetFactoryGitHubAccessTokenPlainArgs].
 */
@PulumiTagMarker
public class GetFactoryGitHubAccessTokenPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var gitHubAccessCode: String? = null

    private var gitHubAccessTokenBaseUrl: String? = null

    private var gitHubClientId: String? = null

    private var gitHubClientSecret: GitHubClientSecret? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("bswwlwitgjnumhaa")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value GitHub access code.
     */
    @JvmName("dblnjxkslqxhpnjx")
    public suspend fun gitHubAccessCode(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gitHubAccessCode = mapped
    }

    /**
     * @param value GitHub access token base URL.
     */
    @JvmName("fognvrgkrvvjmgcj")
    public suspend fun gitHubAccessTokenBaseUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.gitHubAccessTokenBaseUrl = mapped
    }

    /**
     * @param value GitHub application client ID.
     */
    @JvmName("odhtcywyxvmwpoww")
    public suspend fun gitHubClientId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gitHubClientId = mapped
    }

    /**
     * @param value GitHub bring your own app client secret information.
     */
    @JvmName("dajisgmqxaflmvum")
    public suspend fun gitHubClientSecret(`value`: GitHubClientSecret?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.gitHubClientSecret = mapped
    }

    /**
     * @param argument GitHub bring your own app client secret information.
     */
    @JvmName("sodlrsbaautjwlpe")
    public suspend fun gitHubClientSecret(argument: suspend GitHubClientSecretBuilder.() -> Unit) {
        val toBeMapped = GitHubClientSecretBuilder().applySuspend { argument() }.build()
        val mapped = toBeMapped
        this.gitHubClientSecret = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("utvnlbaqkudlhhhn")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetFactoryGitHubAccessTokenPlainArgs = GetFactoryGitHubAccessTokenPlainArgs(
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        gitHubAccessCode = gitHubAccessCode ?: throw PulumiNullFieldException("gitHubAccessCode"),
        gitHubAccessTokenBaseUrl = gitHubAccessTokenBaseUrl ?: throw
            PulumiNullFieldException("gitHubAccessTokenBaseUrl"),
        gitHubClientId = gitHubClientId,
        gitHubClientSecret = gitHubClientSecret,
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
