@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetGlobalParameterPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property globalParameterName The global parameter name.
 * @property resourceGroupName The resource group name.
 */
public data class GetGlobalParameterPlainArgs(
    public val factoryName: String,
    public val globalParameterName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetGlobalParameterPlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetGlobalParameterPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetGlobalParameterPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .globalParameterName(globalParameterName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGlobalParameterPlainArgs].
 */
@PulumiTagMarker
public class GetGlobalParameterPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var globalParameterName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("ddvgndstvcrnxoew")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The global parameter name.
     */
    @JvmName("vibjtqbirhdmqesh")
    public suspend fun globalParameterName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.globalParameterName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("rbhphnsitpkgmpli")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetGlobalParameterPlainArgs = GetGlobalParameterPlainArgs(
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        globalParameterName = globalParameterName ?: throw PulumiNullFieldException("globalParameterName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
