@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeConnectionInfoPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property integrationRuntimeName The integration runtime name.
 * @property resourceGroupName The resource group name.
 */
public data class GetIntegrationRuntimeConnectionInfoPlainArgs(
    public val factoryName: String,
    public val integrationRuntimeName: String,
    public val resourceGroupName: String,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeConnectionInfoPlainArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeConnectionInfoPlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetIntegrationRuntimeConnectionInfoPlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .integrationRuntimeName(integrationRuntimeName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetIntegrationRuntimeConnectionInfoPlainArgs].
 */
@PulumiTagMarker
public class GetIntegrationRuntimeConnectionInfoPlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var integrationRuntimeName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("lbqtlmljknndkcoq")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The integration runtime name.
     */
    @JvmName("myyrkdrlkmpvmeua")
    public suspend fun integrationRuntimeName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.integrationRuntimeName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("pnipplbhpceobyhl")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetIntegrationRuntimeConnectionInfoPlainArgs =
        GetIntegrationRuntimeConnectionInfoPlainArgs(
            factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
            integrationRuntimeName = integrationRuntimeName ?: throw
                PulumiNullFieldException("integrationRuntimeName"),
            resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
        )
}
