@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GetPipelinePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property factoryName The factory name.
 * @property pipelineName The pipeline name.
 * @property resourceGroupName The resource group name.
 */
public data class GetPipelinePlainArgs(
    public val factoryName: String,
    public val pipelineName: String,
    public val resourceGroupName: String,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GetPipelinePlainArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GetPipelinePlainArgs =
        com.pulumi.azurenative.datafactory.inputs.GetPipelinePlainArgs.builder()
            .factoryName(factoryName.let({ args0 -> args0 }))
            .pipelineName(pipelineName.let({ args0 -> args0 }))
            .resourceGroupName(resourceGroupName.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetPipelinePlainArgs].
 */
@PulumiTagMarker
public class GetPipelinePlainArgsBuilder internal constructor() {
    private var factoryName: String? = null

    private var pipelineName: String? = null

    private var resourceGroupName: String? = null

    /**
     * @param value The factory name.
     */
    @JvmName("inqtddohjysebkjn")
    public suspend fun factoryName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.factoryName = mapped
    }

    /**
     * @param value The pipeline name.
     */
    @JvmName("pxnhfgphqeptqvnr")
    public suspend fun pipelineName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.pipelineName = mapped
    }

    /**
     * @param value The resource group name.
     */
    @JvmName("eveanlewlrpynviw")
    public suspend fun resourceGroupName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.resourceGroupName = mapped
    }

    internal fun build(): GetPipelinePlainArgs = GetPipelinePlainArgs(
        factoryName = factoryName ?: throw PulumiNullFieldException("factoryName"),
        pipelineName = pipelineName ?: throw PulumiNullFieldException("pipelineName"),
        resourceGroupName = resourceGroupName ?: throw PulumiNullFieldException("resourceGroupName"),
    )
}
