@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryV2LinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.GoogleBigQueryV2AuthenticationType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Google BigQuery service linked service.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The OAuth 2.0 authentication mechanism used for authentication.
 * @property clientId The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
 * @property clientSecret The client secret of the google application used to acquire the refresh token.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property keyFileContent The content of the .json key file that is used to authenticate the service account. Type: string (or Expression with resultType string).
 * @property parameters Parameters for linked service.
 * @property projectId The default BigQuery project id to query against. Type: string (or Expression with resultType string).
 * @property refreshToken The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
 * @property type Type of linked service.
 * Expected value is 'GoogleBigQueryV2'.
 */
public data class GoogleBigQueryV2LinkedServiceArgs(
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, GoogleBigQueryV2AuthenticationType>>,
    public val clientId: Output<Any>? = null,
    public val clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val keyFileContent: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val projectId: Output<Any>,
    public val refreshToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryV2LinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryV2LinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.GoogleBigQueryV2LinkedServiceArgs.builder()
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .clientId(clientId?.applyValue({ args0 -> args0 }))
            .clientSecret(
                clientSecret?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .keyFileContent(
                keyFileContent?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .projectId(projectId.applyValue({ args0 -> args0 }))
            .refreshToken(
                refreshToken?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GoogleBigQueryV2LinkedServiceArgs].
 */
@PulumiTagMarker
public class GoogleBigQueryV2LinkedServiceArgsBuilder internal constructor() {
    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, GoogleBigQueryV2AuthenticationType>>? = null

    private var clientId: Output<Any>? = null

    private var clientSecret: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var encryptedCredential: Output<String>? = null

    private var keyFileContent: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var projectId: Output<Any>? = null

    private var refreshToken: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? =
        null

    private var type: Output<String>? = null

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("qiirloofmfljjunu")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("xxlrqtugmamegwqg")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("hkdiybkpgbfwdcna")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication.
     */
    @JvmName("adrfubkjfxsgdfrt")
    public suspend
    fun authenticationType(`value`: Output<Either<String, GoogleBigQueryV2AuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
     */
    @JvmName("ajvgpqptggertcho")
    public suspend fun clientId(`value`: Output<Any>) {
        this.clientId = value
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("xqwvhquppwtcqqql")
    public suspend
    fun clientSecret(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.clientSecret = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("uskodfncbxmvbvij")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("nxbperyddmkuarqr")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("amgrxouotpxfqonh")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value The content of the .json key file that is used to authenticate the service account. Type: string (or Expression with resultType string).
     */
    @JvmName("vjbqmpjxwckswnhr")
    public suspend
    fun keyFileContent(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.keyFileContent = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("phtfckevqewaexfw")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The default BigQuery project id to query against. Type: string (or Expression with resultType string).
     */
    @JvmName("fuwgjnckwhwsghho")
    public suspend fun projectId(`value`: Output<Any>) {
        this.projectId = value
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("qqvkuyvneqwsomlu")
    public suspend
    fun refreshToken(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.refreshToken = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'GoogleBigQueryV2'.
     */
    @JvmName("jdojhdqtghblfvft")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("ngqimecikculcfqi")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("lfqnsrllqppybimm")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication.
     */
    @JvmName("qchrmjovxbftmqos")
    public suspend
    fun authenticationType(`value`: Either<String, GoogleBigQueryV2AuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication.
     */
    @JvmName("gbixbylxnuvtvxqr")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, GoogleBigQueryV2AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The OAuth 2.0 authentication mechanism used for authentication.
     */
    @JvmName("xreqgktyaebvhipk")
    public fun authenticationType(`value`: GoogleBigQueryV2AuthenticationType) {
        val toBeMapped = Either.ofRight<String, GoogleBigQueryV2AuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The client id of the google application used to acquire the refresh token. Type: string (or Expression with resultType string).
     */
    @JvmName("acwlreikirwgiyel")
    public suspend fun clientId(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientId = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("ijowgjvbcqnjildx")
    public suspend
    fun clientSecret(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("gyjwlrnshfhfrhvc")
    public fun clientSecret(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The client secret of the google application used to acquire the refresh token.
     */
    @JvmName("xvtcypuenrdxvcin")
    public fun clientSecret(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.clientSecret = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("jhespiugqqpitcts")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("pcplapyqvgxtwecd")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("wyfwwixhhrovrlik")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("ujnjktemibnvclhj")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value The content of the .json key file that is used to authenticate the service account. Type: string (or Expression with resultType string).
     */
    @JvmName("ddcvrctgevnhmiib")
    public suspend
    fun keyFileContent(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.keyFileContent = mapped
    }

    /**
     * @param value The content of the .json key file that is used to authenticate the service account. Type: string (or Expression with resultType string).
     */
    @JvmName("qntsnngxjigwkhfk")
    public fun keyFileContent(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyFileContent = mapped
    }

    /**
     * @param value The content of the .json key file that is used to authenticate the service account. Type: string (or Expression with resultType string).
     */
    @JvmName("ppgtieqiavdbeooi")
    public fun keyFileContent(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.keyFileContent = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("dybdsvlcidmuwwcq")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("hymnwpnfiwylbewy")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("hvmmknqtbfxaqxvh")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The default BigQuery project id to query against. Type: string (or Expression with resultType string).
     */
    @JvmName("myhrhrremowxpyhs")
    public suspend fun projectId(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.projectId = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("tgvqrkrymddbtugy")
    public suspend
    fun refreshToken(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("eywlhnhltywkrisi")
    public fun refreshToken(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value The refresh token obtained from Google for authorizing access to BigQuery for UserAuthentication.
     */
    @JvmName("vbbemmdhsswkwnpb")
    public fun refreshToken(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.refreshToken = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'GoogleBigQueryV2'.
     */
    @JvmName("dlmttrgaqvrxjvmi")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): GoogleBigQueryV2LinkedServiceArgs = GoogleBigQueryV2LinkedServiceArgs(
        annotations = annotations,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        clientId = clientId,
        clientSecret = clientSecret,
        connectVia = connectVia,
        description = description,
        encryptedCredential = encryptedCredential,
        keyFileContent = keyFileContent,
        parameters = parameters,
        projectId = projectId ?: throw PulumiNullFieldException("projectId"),
        refreshToken = refreshToken,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
