@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HiveLinkedServiceArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.HiveAuthenticationType
import com.pulumi.azurenative.datafactory.kotlin.enums.HiveServerType
import com.pulumi.azurenative.datafactory.kotlin.enums.HiveThriftTransportProtocol
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Hive Server linked service.
 * @property allowHostNameCNMismatch Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
 * @property allowSelfSignedServerCert Specifies whether to allow self-signed certificates from the server. The default value is false.
 * @property annotations List of tags that can be used for describing the linked service.
 * @property authenticationType The authentication method used to access the Hive server.
 * @property connectVia The integration runtime reference.
 * @property description Linked service description.
 * @property enableSsl Specifies whether the connections to the server are encrypted using SSL. The default value is false.
 * @property encryptedCredential The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
 * @property host IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
 * @property httpPath The partial URL corresponding to the Hive server.
 * @property parameters Parameters for linked service.
 * @property password The password corresponding to the user name that you provided in the Username field
 * @property port The TCP port that the Hive server uses to listen for client connections.
 * @property serverType The type of Hive server.
 * @property serviceDiscoveryMode true to indicate using the ZooKeeper service, false not.
 * @property thriftTransportProtocol The transport protocol to use in the Thrift layer.
 * @property trustedCertPath The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
 * @property type Type of linked service.
 * Expected value is 'Hive'.
 * @property useNativeQuery Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
 * @property useSystemTrustStore Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
 * @property username The user name that you use to access Hive Server.
 * @property zooKeeperNameSpace The namespace on ZooKeeper under which Hive Server 2 nodes are added.
 */
public data class HiveLinkedServiceArgs(
    public val allowHostNameCNMismatch: Output<Any>? = null,
    public val allowSelfSignedServerCert: Output<Any>? = null,
    public val annotations: Output<List<Any>>? = null,
    public val authenticationType: Output<Either<String, HiveAuthenticationType>>,
    public val connectVia: Output<IntegrationRuntimeReferenceArgs>? = null,
    public val description: Output<String>? = null,
    public val enableSsl: Output<Any>? = null,
    public val encryptedCredential: Output<String>? = null,
    public val host: Output<Any>,
    public val httpPath: Output<Any>? = null,
    public val parameters: Output<Map<String, ParameterSpecificationArgs>>? = null,
    public val password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null,
    public val port: Output<Any>? = null,
    public val serverType: Output<Either<String, HiveServerType>>? = null,
    public val serviceDiscoveryMode: Output<Any>? = null,
    public val thriftTransportProtocol: Output<Either<String, HiveThriftTransportProtocol>>? = null,
    public val trustedCertPath: Output<Any>? = null,
    public val type: Output<String>,
    public val useNativeQuery: Output<Any>? = null,
    public val useSystemTrustStore: Output<Any>? = null,
    public val username: Output<Any>? = null,
    public val zooKeeperNameSpace: Output<Any>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HiveLinkedServiceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HiveLinkedServiceArgs =
        com.pulumi.azurenative.datafactory.inputs.HiveLinkedServiceArgs.builder()
            .allowHostNameCNMismatch(allowHostNameCNMismatch?.applyValue({ args0 -> args0 }))
            .allowSelfSignedServerCert(allowSelfSignedServerCert?.applyValue({ args0 -> args0 }))
            .annotations(annotations?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .authenticationType(
                authenticationType.applyValue({ args0 ->
                    args0.transform(
                        { args0 -> args0 },
                        { args0 -> args0.let({ args0 -> args0.toJava() }) },
                    )
                }),
            )
            .connectVia(connectVia?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .description(description?.applyValue({ args0 -> args0 }))
            .enableSsl(enableSsl?.applyValue({ args0 -> args0 }))
            .encryptedCredential(encryptedCredential?.applyValue({ args0 -> args0 }))
            .host(host.applyValue({ args0 -> args0 }))
            .httpPath(httpPath?.applyValue({ args0 -> args0 }))
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value.let({ args0 -> args0.toJava() }))
                    }).toMap()
                }),
            )
            .password(
                password?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .port(port?.applyValue({ args0 -> args0 }))
            .serverType(
                serverType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .serviceDiscoveryMode(serviceDiscoveryMode?.applyValue({ args0 -> args0 }))
            .thriftTransportProtocol(
                thriftTransportProtocol?.applyValue({ args0 ->
                    args0.transform({ args0 ->
                        args0
                    }, { args0 -> args0.let({ args0 -> args0.toJava() }) })
                }),
            )
            .trustedCertPath(trustedCertPath?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 }))
            .useNativeQuery(useNativeQuery?.applyValue({ args0 -> args0 }))
            .useSystemTrustStore(useSystemTrustStore?.applyValue({ args0 -> args0 }))
            .username(username?.applyValue({ args0 -> args0 }))
            .zooKeeperNameSpace(zooKeeperNameSpace?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HiveLinkedServiceArgs].
 */
@PulumiTagMarker
public class HiveLinkedServiceArgsBuilder internal constructor() {
    private var allowHostNameCNMismatch: Output<Any>? = null

    private var allowSelfSignedServerCert: Output<Any>? = null

    private var annotations: Output<List<Any>>? = null

    private var authenticationType: Output<Either<String, HiveAuthenticationType>>? = null

    private var connectVia: Output<IntegrationRuntimeReferenceArgs>? = null

    private var description: Output<String>? = null

    private var enableSsl: Output<Any>? = null

    private var encryptedCredential: Output<String>? = null

    private var host: Output<Any>? = null

    private var httpPath: Output<Any>? = null

    private var parameters: Output<Map<String, ParameterSpecificationArgs>>? = null

    private var password: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>? = null

    private var port: Output<Any>? = null

    private var serverType: Output<Either<String, HiveServerType>>? = null

    private var serviceDiscoveryMode: Output<Any>? = null

    private var thriftTransportProtocol: Output<Either<String, HiveThriftTransportProtocol>>? = null

    private var trustedCertPath: Output<Any>? = null

    private var type: Output<String>? = null

    private var useNativeQuery: Output<Any>? = null

    private var useSystemTrustStore: Output<Any>? = null

    private var username: Output<Any>? = null

    private var zooKeeperNameSpace: Output<Any>? = null

    /**
     * @param value Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
     */
    @JvmName("qtotserpuvoiawpc")
    public suspend fun allowHostNameCNMismatch(`value`: Output<Any>) {
        this.allowHostNameCNMismatch = value
    }

    /**
     * @param value Specifies whether to allow self-signed certificates from the server. The default value is false.
     */
    @JvmName("jlxskvwfpnarlwmo")
    public suspend fun allowSelfSignedServerCert(`value`: Output<Any>) {
        this.allowSelfSignedServerCert = value
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("jnaiitphkodwuilh")
    public suspend fun annotations(`value`: Output<List<Any>>) {
        this.annotations = value
    }

    @JvmName("vwtdgcsgfqmkcjjg")
    public suspend fun annotations(vararg values: Output<Any>) {
        this.annotations = Output.all(values.asList())
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("qeiofvojihxlhhqp")
    public suspend fun annotations(values: List<Output<Any>>) {
        this.annotations = Output.all(values)
    }

    /**
     * @param value The authentication method used to access the Hive server.
     */
    @JvmName("iwwghvmrvdxtlibu")
    public suspend fun authenticationType(`value`: Output<Either<String, HiveAuthenticationType>>) {
        this.authenticationType = value
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("anxdcrgsotxdwykx")
    public suspend fun connectVia(`value`: Output<IntegrationRuntimeReferenceArgs>) {
        this.connectVia = value
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("eieexneuemsbxavo")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Specifies whether the connections to the server are encrypted using SSL. The default value is false.
     */
    @JvmName("gykpvwyssphyfrnw")
    public suspend fun enableSsl(`value`: Output<Any>) {
        this.enableSsl = value
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("phqbquwqphbnnyug")
    public suspend fun encryptedCredential(`value`: Output<String>) {
        this.encryptedCredential = value
    }

    /**
     * @param value IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
     */
    @JvmName("ebnjheevubvcytxq")
    public suspend fun host(`value`: Output<Any>) {
        this.host = value
    }

    /**
     * @param value The partial URL corresponding to the Hive server.
     */
    @JvmName("ggjfhtpekvywccfk")
    public suspend fun httpPath(`value`: Output<Any>) {
        this.httpPath = value
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("gbtaitxdqiqlpjah")
    public suspend fun parameters(`value`: Output<Map<String, ParameterSpecificationArgs>>) {
        this.parameters = value
    }

    /**
     * @param value The password corresponding to the user name that you provided in the Username field
     */
    @JvmName("brnbhjlhtmhysgux")
    public suspend
    fun password(`value`: Output<Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>>) {
        this.password = value
    }

    /**
     * @param value The TCP port that the Hive server uses to listen for client connections.
     */
    @JvmName("oqkyrbohuousbqym")
    public suspend fun port(`value`: Output<Any>) {
        this.port = value
    }

    /**
     * @param value The type of Hive server.
     */
    @JvmName("fjrkoybjrulnwkpt")
    public suspend fun serverType(`value`: Output<Either<String, HiveServerType>>) {
        this.serverType = value
    }

    /**
     * @param value true to indicate using the ZooKeeper service, false not.
     */
    @JvmName("fmthdixpvdralkqd")
    public suspend fun serviceDiscoveryMode(`value`: Output<Any>) {
        this.serviceDiscoveryMode = value
    }

    /**
     * @param value The transport protocol to use in the Thrift layer.
     */
    @JvmName("bjwityerjvohaqmv")
    public suspend
    fun thriftTransportProtocol(`value`: Output<Either<String, HiveThriftTransportProtocol>>) {
        this.thriftTransportProtocol = value
    }

    /**
     * @param value The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
     */
    @JvmName("wyuwatwlkyhrdfha")
    public suspend fun trustedCertPath(`value`: Output<Any>) {
        this.trustedCertPath = value
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Hive'.
     */
    @JvmName("rpjsqmjndqyixomg")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
     */
    @JvmName("nknrubrvbsseavwb")
    public suspend fun useNativeQuery(`value`: Output<Any>) {
        this.useNativeQuery = value
    }

    /**
     * @param value Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
     */
    @JvmName("pxsavkumlkghsmig")
    public suspend fun useSystemTrustStore(`value`: Output<Any>) {
        this.useSystemTrustStore = value
    }

    /**
     * @param value The user name that you use to access Hive Server.
     */
    @JvmName("cktnciiribfmpjqm")
    public suspend fun username(`value`: Output<Any>) {
        this.username = value
    }

    /**
     * @param value The namespace on ZooKeeper under which Hive Server 2 nodes are added.
     */
    @JvmName("qgmkdqwqhchxdwkb")
    public suspend fun zooKeeperNameSpace(`value`: Output<Any>) {
        this.zooKeeperNameSpace = value
    }

    /**
     * @param value Specifies whether to require a CA-issued SSL certificate name to match the host name of the server when connecting over SSL. The default value is false.
     */
    @JvmName("hyuxxfdmfqyqltwi")
    public suspend fun allowHostNameCNMismatch(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowHostNameCNMismatch = mapped
    }

    /**
     * @param value Specifies whether to allow self-signed certificates from the server. The default value is false.
     */
    @JvmName("dnxqptohylbcfsrd")
    public suspend fun allowSelfSignedServerCert(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.allowSelfSignedServerCert = mapped
    }

    /**
     * @param value List of tags that can be used for describing the linked service.
     */
    @JvmName("kpotdtisbrdfjfyu")
    public suspend fun annotations(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param values List of tags that can be used for describing the linked service.
     */
    @JvmName("mlhtuutgioejrvey")
    public suspend fun annotations(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.annotations = mapped
    }

    /**
     * @param value The authentication method used to access the Hive server.
     */
    @JvmName("wtnnweqjvhrqavds")
    public suspend fun authenticationType(`value`: Either<String, HiveAuthenticationType>) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication method used to access the Hive server.
     */
    @JvmName("rdtcgkndidtwtfci")
    public fun authenticationType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HiveAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The authentication method used to access the Hive server.
     */
    @JvmName("uvecypgdhochxmwg")
    public fun authenticationType(`value`: HiveAuthenticationType) {
        val toBeMapped = Either.ofRight<String, HiveAuthenticationType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value The integration runtime reference.
     */
    @JvmName("nuvacntrblheyfas")
    public suspend fun connectVia(`value`: IntegrationRuntimeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectVia = mapped
    }

    /**
     * @param argument The integration runtime reference.
     */
    @JvmName("rqwwkyefqllnglcp")
    public suspend
    fun connectVia(argument: suspend IntegrationRuntimeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.connectVia = mapped
    }

    /**
     * @param value Linked service description.
     */
    @JvmName("oloirmolwuloyjox")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Specifies whether the connections to the server are encrypted using SSL. The default value is false.
     */
    @JvmName("xiaojjgdwcpbnxnv")
    public suspend fun enableSsl(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableSsl = mapped
    }

    /**
     * @param value The encrypted credential used for authentication. Credentials are encrypted using the integration runtime credential manager. Type: string.
     */
    @JvmName("lcxnobtkuhyfdrxh")
    public suspend fun encryptedCredential(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptedCredential = mapped
    }

    /**
     * @param value IP address or host name of the Hive server, separated by ';' for multiple hosts (only when serviceDiscoveryMode is enable).
     */
    @JvmName("yqebeipbgdfewyfp")
    public suspend fun host(`value`: Any) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.host = mapped
    }

    /**
     * @param value The partial URL corresponding to the Hive server.
     */
    @JvmName("psfcqbqxusuurmlr")
    public suspend fun httpPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.httpPath = mapped
    }

    /**
     * @param value Parameters for linked service.
     */
    @JvmName("nicivyxjvmhjjcvg")
    public suspend fun parameters(`value`: Map<String, ParameterSpecificationArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param argument Parameters for linked service.
     */
    @JvmName("qlferggkseaptbej")
    public suspend fun parameters(
        vararg
        argument: Pair<String, suspend ParameterSpecificationArgsBuilder.() -> Unit>,
    ) {
        val toBeMapped = argument.toList().map { (left, right) ->
            left to
                ParameterSpecificationArgsBuilder().applySuspend { right() }.build()
        }.toMap()
        val mapped = of(toBeMapped)
        this.parameters = mapped
    }

    /**
     * @param values Parameters for linked service.
     */
    @JvmName("ncxclmafasusgqoe")
    public fun parameters(vararg values: Pair<String, ParameterSpecificationArgs>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value The password corresponding to the user name that you provided in the Username field
     */
    @JvmName("hhdfmxlwydgvluht")
    public suspend
    fun password(`value`: Either<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name that you provided in the Username field
     */
    @JvmName("unbbfpidkucsxtxl")
    public fun password(`value`: AzureKeyVaultSecretReferenceArgs) {
        val toBeMapped = Either.ofLeft<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The password corresponding to the user name that you provided in the Username field
     */
    @JvmName("dxiwfqmvrseesdbt")
    public fun password(`value`: SecureStringArgs) {
        val toBeMapped = Either.ofRight<AzureKeyVaultSecretReferenceArgs, SecureStringArgs>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.password = mapped
    }

    /**
     * @param value The TCP port that the Hive server uses to listen for client connections.
     */
    @JvmName("ylyjuolbaxqqglci")
    public suspend fun port(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value The type of Hive server.
     */
    @JvmName("yctdwcnkplvjqaxd")
    public suspend fun serverType(`value`: Either<String, HiveServerType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serverType = mapped
    }

    /**
     * @param value The type of Hive server.
     */
    @JvmName("jygogdwsfihkrppy")
    public fun serverType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HiveServerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverType = mapped
    }

    /**
     * @param value The type of Hive server.
     */
    @JvmName("rusakqxseqpkpghq")
    public fun serverType(`value`: HiveServerType) {
        val toBeMapped = Either.ofRight<String, HiveServerType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.serverType = mapped
    }

    /**
     * @param value true to indicate using the ZooKeeper service, false not.
     */
    @JvmName("ghsvgyxjsgqwonod")
    public suspend fun serviceDiscoveryMode(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceDiscoveryMode = mapped
    }

    /**
     * @param value The transport protocol to use in the Thrift layer.
     */
    @JvmName("ccchcckrsmctyvkj")
    public suspend
    fun thriftTransportProtocol(`value`: Either<String, HiveThriftTransportProtocol>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.thriftTransportProtocol = mapped
    }

    /**
     * @param value The transport protocol to use in the Thrift layer.
     */
    @JvmName("achhlipgbuayqhlr")
    public fun thriftTransportProtocol(`value`: String) {
        val toBeMapped = Either.ofLeft<String, HiveThriftTransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thriftTransportProtocol = mapped
    }

    /**
     * @param value The transport protocol to use in the Thrift layer.
     */
    @JvmName("vpjokhidutymwvjq")
    public fun thriftTransportProtocol(`value`: HiveThriftTransportProtocol) {
        val toBeMapped = Either.ofRight<String, HiveThriftTransportProtocol>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.thriftTransportProtocol = mapped
    }

    /**
     * @param value The full path of the .pem file containing trusted CA certificates for verifying the server when connecting over SSL. This property can only be set when using SSL on self-hosted IR. The default value is the cacerts.pem file installed with the IR.
     */
    @JvmName("qjygowcvyhicbywe")
    public suspend fun trustedCertPath(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.trustedCertPath = mapped
    }

    /**
     * @param value Type of linked service.
     * Expected value is 'Hive'.
     */
    @JvmName("aylfunjfnqleyqda")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Specifies whether the driver uses native HiveQL queries,or converts them into an equivalent form in HiveQL.
     */
    @JvmName("ogwyjnfjihdyevxm")
    public suspend fun useNativeQuery(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useNativeQuery = mapped
    }

    /**
     * @param value Specifies whether to use a CA certificate from the system trust store or from a specified PEM file. The default value is false.
     */
    @JvmName("ejghaaosuvtrjjvq")
    public suspend fun useSystemTrustStore(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.useSystemTrustStore = mapped
    }

    /**
     * @param value The user name that you use to access Hive Server.
     */
    @JvmName("httppjopqmektdqr")
    public suspend fun username(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.username = mapped
    }

    /**
     * @param value The namespace on ZooKeeper under which Hive Server 2 nodes are added.
     */
    @JvmName("xxpqjodynbwhngph")
    public suspend fun zooKeeperNameSpace(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.zooKeeperNameSpace = mapped
    }

    internal fun build(): HiveLinkedServiceArgs = HiveLinkedServiceArgs(
        allowHostNameCNMismatch = allowHostNameCNMismatch,
        allowSelfSignedServerCert = allowSelfSignedServerCert,
        annotations = annotations,
        authenticationType = authenticationType ?: throw PulumiNullFieldException("authenticationType"),
        connectVia = connectVia,
        description = description,
        enableSsl = enableSsl,
        encryptedCredential = encryptedCredential,
        host = host ?: throw PulumiNullFieldException("host"),
        httpPath = httpPath,
        parameters = parameters,
        password = password,
        port = port,
        serverType = serverType,
        serviceDiscoveryMode = serviceDiscoveryMode,
        thriftTransportProtocol = thriftTransportProtocol,
        trustedCertPath = trustedCertPath,
        type = type ?: throw PulumiNullFieldException("type"),
        useNativeQuery = useNativeQuery,
        useSystemTrustStore = useSystemTrustStore,
        username = username,
        zooKeeperNameSpace = zooKeeperNameSpace,
    )
}
