@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.HttpReadSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Http read settings.
 * @property additionalColumns Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
 * @property additionalHeaders The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
 * @property disableMetricsCollection If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
 * @property maxConcurrentConnections The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
 * @property requestBody The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
 * @property requestMethod The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
 * @property requestTimeout Specifies the timeout for a HTTP client to get HTTP response from HTTP server. Type: string (or Expression with resultType string).
 * @property type The read setting type.
 * Expected value is 'HttpReadSettings'.
 */
public data class HttpReadSettingsArgs(
    public val additionalColumns: Output<Any>? = null,
    public val additionalHeaders: Output<Any>? = null,
    public val disableMetricsCollection: Output<Any>? = null,
    public val maxConcurrentConnections: Output<Any>? = null,
    public val requestBody: Output<Any>? = null,
    public val requestMethod: Output<Any>? = null,
    public val requestTimeout: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.HttpReadSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.HttpReadSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.HttpReadSettingsArgs.builder()
            .additionalColumns(additionalColumns?.applyValue({ args0 -> args0 }))
            .additionalHeaders(additionalHeaders?.applyValue({ args0 -> args0 }))
            .disableMetricsCollection(disableMetricsCollection?.applyValue({ args0 -> args0 }))
            .maxConcurrentConnections(maxConcurrentConnections?.applyValue({ args0 -> args0 }))
            .requestBody(requestBody?.applyValue({ args0 -> args0 }))
            .requestMethod(requestMethod?.applyValue({ args0 -> args0 }))
            .requestTimeout(requestTimeout?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HttpReadSettingsArgs].
 */
@PulumiTagMarker
public class HttpReadSettingsArgsBuilder internal constructor() {
    private var additionalColumns: Output<Any>? = null

    private var additionalHeaders: Output<Any>? = null

    private var disableMetricsCollection: Output<Any>? = null

    private var maxConcurrentConnections: Output<Any>? = null

    private var requestBody: Output<Any>? = null

    private var requestMethod: Output<Any>? = null

    private var requestTimeout: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("yxoodkubhomjjbtp")
    public suspend fun additionalColumns(`value`: Output<Any>) {
        this.additionalColumns = value
    }

    /**
     * @param value The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
     */
    @JvmName("dytxmvdbgnoabgwh")
    public suspend fun additionalHeaders(`value`: Output<Any>) {
        this.additionalHeaders = value
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("fqwdqrtuyruvaevp")
    public suspend fun disableMetricsCollection(`value`: Output<Any>) {
        this.disableMetricsCollection = value
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("lpwqhoanndhlrbbc")
    public suspend fun maxConcurrentConnections(`value`: Output<Any>) {
        this.maxConcurrentConnections = value
    }

    /**
     * @param value The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("efphashgoykcaryk")
    public suspend fun requestBody(`value`: Output<Any>) {
        this.requestBody = value
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
     */
    @JvmName("bkjhetiweqndshhn")
    public suspend fun requestMethod(`value`: Output<Any>) {
        this.requestMethod = value
    }

    /**
     * @param value Specifies the timeout for a HTTP client to get HTTP response from HTTP server. Type: string (or Expression with resultType string).
     */
    @JvmName("jqgssayvcwxlkkjx")
    public suspend fun requestTimeout(`value`: Output<Any>) {
        this.requestTimeout = value
    }

    /**
     * @param value The read setting type.
     * Expected value is 'HttpReadSettings'.
     */
    @JvmName("krtvjtejrhhqyxmy")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Specifies the additional columns to be added to source data. Type: array of objects(AdditionalColumns) (or Expression with resultType array of objects).
     */
    @JvmName("swmxphqdinokweoc")
    public suspend fun additionalColumns(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalColumns = mapped
    }

    /**
     * @param value The additional HTTP headers in the request to the RESTful API. Type: string (or Expression with resultType string).
     */
    @JvmName("tnuxejhopkglpbuw")
    public suspend fun additionalHeaders(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.additionalHeaders = mapped
    }

    /**
     * @param value If true, disable data store metrics collection. Default is false. Type: boolean (or Expression with resultType boolean).
     */
    @JvmName("votbmaungifopnms")
    public suspend fun disableMetricsCollection(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.disableMetricsCollection = mapped
    }

    /**
     * @param value The maximum concurrent connection count for the source data store. Type: integer (or Expression with resultType integer).
     */
    @JvmName("umpvhlkhqapkrwhu")
    public suspend fun maxConcurrentConnections(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.maxConcurrentConnections = mapped
    }

    /**
     * @param value The HTTP request body to the RESTful API if requestMethod is POST. Type: string (or Expression with resultType string).
     */
    @JvmName("hfmnsngprpowpqxt")
    public suspend fun requestBody(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestBody = mapped
    }

    /**
     * @param value The HTTP method used to call the RESTful API. The default is GET. Type: string (or Expression with resultType string).
     */
    @JvmName("jnwpnfedqrhklnnc")
    public suspend fun requestMethod(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestMethod = mapped
    }

    /**
     * @param value Specifies the timeout for a HTTP client to get HTTP response from HTTP server. Type: string (or Expression with resultType string).
     */
    @JvmName("dohbuwxdnhuujlpv")
    public suspend fun requestTimeout(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.requestTimeout = mapped
    }

    /**
     * @param value The read setting type.
     * Expected value is 'HttpReadSettings'.
     */
    @JvmName("qkjothnocalmifim")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): HttpReadSettingsArgs = HttpReadSettingsArgs(
        additionalColumns = additionalColumns,
        additionalHeaders = additionalHeaders,
        disableMetricsCollection = disableMetricsCollection,
        maxConcurrentConnections = maxConcurrentConnections,
        requestBody = requestBody,
        requestMethod = requestMethod,
        requestTimeout = requestTimeout,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
