@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomSetupScriptPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Custom setup script properties for a managed dedicated integration runtime.
 * @property blobContainerUri The URI of the Azure blob container that contains the custom setup script.
 * @property sasToken The SAS token of the Azure blob container.
 */
public data class IntegrationRuntimeCustomSetupScriptPropertiesArgs(
    public val blobContainerUri: Output<String>? = null,
    public val sasToken: Output<SecureStringArgs>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomSetupScriptPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomSetupScriptPropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeCustomSetupScriptPropertiesArgs.builder()
            .blobContainerUri(blobContainerUri?.applyValue({ args0 -> args0 }))
            .sasToken(sasToken?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [IntegrationRuntimeCustomSetupScriptPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeCustomSetupScriptPropertiesArgsBuilder internal constructor() {
    private var blobContainerUri: Output<String>? = null

    private var sasToken: Output<SecureStringArgs>? = null

    /**
     * @param value The URI of the Azure blob container that contains the custom setup script.
     */
    @JvmName("fwifmrpncinwnwha")
    public suspend fun blobContainerUri(`value`: Output<String>) {
        this.blobContainerUri = value
    }

    /**
     * @param value The SAS token of the Azure blob container.
     */
    @JvmName("lkqcplxwexjyqrwo")
    public suspend fun sasToken(`value`: Output<SecureStringArgs>) {
        this.sasToken = value
    }

    /**
     * @param value The URI of the Azure blob container that contains the custom setup script.
     */
    @JvmName("qtgxlurlnibecmvq")
    public suspend fun blobContainerUri(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.blobContainerUri = mapped
    }

    /**
     * @param value The SAS token of the Azure blob container.
     */
    @JvmName("vdvorcrjxcesstxs")
    public suspend fun sasToken(`value`: SecureStringArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sasToken = mapped
    }

    /**
     * @param argument The SAS token of the Azure blob container.
     */
    @JvmName("hgpxemgtlovginqm")
    public suspend fun sasToken(argument: suspend SecureStringArgsBuilder.() -> Unit) {
        val toBeMapped = SecureStringArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sasToken = mapped
    }

    internal fun build(): IntegrationRuntimeCustomSetupScriptPropertiesArgs =
        IntegrationRuntimeCustomSetupScriptPropertiesArgs(
            blobContainerUri = blobContainerUri,
            sasToken = sasToken,
        )
}
