@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name Name of custom property.
 * @property value Value of custom property.
 */
public data class IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Name of custom property.
     */
    @JvmName("tmidualbhhiyqcrg")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Value of custom property.
     */
    @JvmName("pxqfualumibrmslp")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Name of custom property.
     */
    @JvmName("fcwqxxvpwaieacxc")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Value of custom property.
     */
    @JvmName("mcleejfxacxjiysw")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs =
        IntegrationRuntimeDataFlowPropertiesCustomPropertiesArgs(
            name = name,
            `value` = `value`,
        )
}
