@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeReferenceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Integration runtime reference type.
 * @property parameters Arguments for integration runtime.
 * @property referenceName Reference integration runtime name.
 * @property type Type of integration runtime.
 */
public data class IntegrationRuntimeReferenceArgs(
    public val parameters: Output<Map<String, Any>>? = null,
    public val referenceName: Output<String>,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeReferenceArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeReferenceArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeReferenceArgs.builder()
            .parameters(
                parameters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .referenceName(referenceName.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [IntegrationRuntimeReferenceArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeReferenceArgsBuilder internal constructor() {
    private var parameters: Output<Map<String, Any>>? = null

    private var referenceName: Output<String>? = null

    private var type: Output<String>? = null

    /**
     * @param value Arguments for integration runtime.
     */
    @JvmName("sabfuifsrrlapjjp")
    public suspend fun parameters(`value`: Output<Map<String, Any>>) {
        this.parameters = value
    }

    /**
     * @param value Reference integration runtime name.
     */
    @JvmName("nkbkeovwtvpehhkr")
    public suspend fun referenceName(`value`: Output<String>) {
        this.referenceName = value
    }

    /**
     * @param value Type of integration runtime.
     */
    @JvmName("hnfnoaempyckrsxa")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Arguments for integration runtime.
     */
    @JvmName("uvvqxymluyfcotsk")
    public suspend fun parameters(`value`: Map<String, Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param values Arguments for integration runtime.
     */
    @JvmName("rohoyrgrlexqlugo")
    public fun parameters(vararg values: Pair<String, Any>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.parameters = mapped
    }

    /**
     * @param value Reference integration runtime name.
     */
    @JvmName("gsjqgbhdailojeuk")
    public suspend fun referenceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.referenceName = mapped
    }

    /**
     * @param value Type of integration runtime.
     */
    @JvmName("jrufsrwburpqfsxm")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): IntegrationRuntimeReferenceArgs = IntegrationRuntimeReferenceArgs(
        parameters = parameters,
        referenceName = referenceName ?: throw PulumiNullFieldException("referenceName"),
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
