@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisPropertiesArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.IntegrationRuntimeEdition
import com.pulumi.azurenative.datafactory.kotlin.enums.IntegrationRuntimeLicenseType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * SSIS properties for managed integration runtime.
 * @property catalogInfo Catalog information for managed dedicated integration runtime.
 * @property credential The credential reference containing authentication information.
 * @property customSetupScriptProperties Custom setup script properties for a managed dedicated integration runtime.
 * @property dataProxyProperties Data proxy properties for a managed dedicated integration runtime.
 * @property edition The edition for the SSIS Integration Runtime
 * @property expressCustomSetupProperties Custom setup without script properties for a SSIS integration runtime.
 * @property licenseType License type for bringing your own license scenario.
 * @property packageStores Package stores for the SSIS Integration Runtime.
 */
public data class IntegrationRuntimeSsisPropertiesArgs(
    public val catalogInfo: Output<IntegrationRuntimeSsisCatalogInfoArgs>? = null,
    public val credential: Output<CredentialReferenceArgs>? = null,
    public val customSetupScriptProperties: Output<IntegrationRuntimeCustomSetupScriptPropertiesArgs>? =
        null,
    public val dataProxyProperties: Output<IntegrationRuntimeDataProxyPropertiesArgs>? = null,
    public val edition: Output<Either<String, IntegrationRuntimeEdition>>? = null,
    public val expressCustomSetupProperties: Output<List<Any>>? = null,
    public val licenseType: Output<Either<String, IntegrationRuntimeLicenseType>>? = null,
    public val packageStores: Output<List<PackageStoreArgs>>? = null,
) :
    ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisPropertiesArgs> {
    override fun toJava():
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisPropertiesArgs =
        com.pulumi.azurenative.datafactory.inputs.IntegrationRuntimeSsisPropertiesArgs.builder()
            .catalogInfo(catalogInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .credential(credential?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customSetupScriptProperties(
                customSetupScriptProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .dataProxyProperties(
                dataProxyProperties?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .edition(
                edition?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expressCustomSetupProperties(
                expressCustomSetupProperties?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .licenseType(
                licenseType?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .packageStores(
                packageStores?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [IntegrationRuntimeSsisPropertiesArgs].
 */
@PulumiTagMarker
public class IntegrationRuntimeSsisPropertiesArgsBuilder internal constructor() {
    private var catalogInfo: Output<IntegrationRuntimeSsisCatalogInfoArgs>? = null

    private var credential: Output<CredentialReferenceArgs>? = null

    private var customSetupScriptProperties:
        Output<IntegrationRuntimeCustomSetupScriptPropertiesArgs>? = null

    private var dataProxyProperties: Output<IntegrationRuntimeDataProxyPropertiesArgs>? = null

    private var edition: Output<Either<String, IntegrationRuntimeEdition>>? = null

    private var expressCustomSetupProperties: Output<List<Any>>? = null

    private var licenseType: Output<Either<String, IntegrationRuntimeLicenseType>>? = null

    private var packageStores: Output<List<PackageStoreArgs>>? = null

    /**
     * @param value Catalog information for managed dedicated integration runtime.
     */
    @JvmName("yrcfslfdikfxmvnn")
    public suspend fun catalogInfo(`value`: Output<IntegrationRuntimeSsisCatalogInfoArgs>) {
        this.catalogInfo = value
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("vrhmkvfcsqsrfljx")
    public suspend fun credential(`value`: Output<CredentialReferenceArgs>) {
        this.credential = value
    }

    /**
     * @param value Custom setup script properties for a managed dedicated integration runtime.
     */
    @JvmName("npsaipisrnjcswnn")
    public suspend
    fun customSetupScriptProperties(`value`: Output<IntegrationRuntimeCustomSetupScriptPropertiesArgs>) {
        this.customSetupScriptProperties = value
    }

    /**
     * @param value Data proxy properties for a managed dedicated integration runtime.
     */
    @JvmName("qvewdnpndxilgiyg")
    public suspend
    fun dataProxyProperties(`value`: Output<IntegrationRuntimeDataProxyPropertiesArgs>) {
        this.dataProxyProperties = value
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("bgveaekdwawuvahf")
    public suspend fun edition(`value`: Output<Either<String, IntegrationRuntimeEdition>>) {
        this.edition = value
    }

    /**
     * @param value Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("edoecotxyegdqwvb")
    public suspend fun expressCustomSetupProperties(`value`: Output<List<Any>>) {
        this.expressCustomSetupProperties = value
    }

    @JvmName("fhnjvkgltlxeerar")
    public suspend fun expressCustomSetupProperties(vararg values: Output<Any>) {
        this.expressCustomSetupProperties = Output.all(values.asList())
    }

    /**
     * @param values Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("rvuukdsjncghhxwo")
    public suspend fun expressCustomSetupProperties(values: List<Output<Any>>) {
        this.expressCustomSetupProperties = Output.all(values)
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("srwwkefrwyghhsmy")
    public suspend fun licenseType(`value`: Output<Either<String, IntegrationRuntimeLicenseType>>) {
        this.licenseType = value
    }

    /**
     * @param value Package stores for the SSIS Integration Runtime.
     */
    @JvmName("qwnqttqtbqkvcwtf")
    public suspend fun packageStores(`value`: Output<List<PackageStoreArgs>>) {
        this.packageStores = value
    }

    @JvmName("mghsgkjoqtbmomdl")
    public suspend fun packageStores(vararg values: Output<PackageStoreArgs>) {
        this.packageStores = Output.all(values.asList())
    }

    /**
     * @param values Package stores for the SSIS Integration Runtime.
     */
    @JvmName("dtsdpnpatludhcye")
    public suspend fun packageStores(values: List<Output<PackageStoreArgs>>) {
        this.packageStores = Output.all(values)
    }

    /**
     * @param value Catalog information for managed dedicated integration runtime.
     */
    @JvmName("mfnxaomlvgpdswxi")
    public suspend fun catalogInfo(`value`: IntegrationRuntimeSsisCatalogInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.catalogInfo = mapped
    }

    /**
     * @param argument Catalog information for managed dedicated integration runtime.
     */
    @JvmName("bxcivommbkopncwk")
    public suspend
    fun catalogInfo(argument: suspend IntegrationRuntimeSsisCatalogInfoArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeSsisCatalogInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.catalogInfo = mapped
    }

    /**
     * @param value The credential reference containing authentication information.
     */
    @JvmName("jcsywirigqcrhdgq")
    public suspend fun credential(`value`: CredentialReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.credential = mapped
    }

    /**
     * @param argument The credential reference containing authentication information.
     */
    @JvmName("wcgjogmblxsnjyhl")
    public suspend fun credential(argument: suspend CredentialReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = CredentialReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.credential = mapped
    }

    /**
     * @param value Custom setup script properties for a managed dedicated integration runtime.
     */
    @JvmName("wiitrtsqxyiqnnsf")
    public suspend
    fun customSetupScriptProperties(`value`: IntegrationRuntimeCustomSetupScriptPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customSetupScriptProperties = mapped
    }

    /**
     * @param argument Custom setup script properties for a managed dedicated integration runtime.
     */
    @JvmName("kljlyncuxevmoatl")
    public suspend
    fun customSetupScriptProperties(argument: suspend IntegrationRuntimeCustomSetupScriptPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeCustomSetupScriptPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customSetupScriptProperties = mapped
    }

    /**
     * @param value Data proxy properties for a managed dedicated integration runtime.
     */
    @JvmName("tdqkrejlfacyxkdk")
    public suspend fun dataProxyProperties(`value`: IntegrationRuntimeDataProxyPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.dataProxyProperties = mapped
    }

    /**
     * @param argument Data proxy properties for a managed dedicated integration runtime.
     */
    @JvmName("gdpkuajfuwkjaxek")
    public suspend
    fun dataProxyProperties(argument: suspend IntegrationRuntimeDataProxyPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeDataProxyPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.dataProxyProperties = mapped
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("tbfvxuohhgreyxai")
    public suspend fun edition(`value`: Either<String, IntegrationRuntimeEdition>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("rmasbaienerqqlov")
    public fun edition(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationRuntimeEdition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value The edition for the SSIS Integration Runtime
     */
    @JvmName("ajvhtbktfanrwgyr")
    public fun edition(`value`: IntegrationRuntimeEdition) {
        val toBeMapped = Either.ofRight<String, IntegrationRuntimeEdition>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.edition = mapped
    }

    /**
     * @param value Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("eanxqfuloovpktvn")
    public suspend fun expressCustomSetupProperties(`value`: List<Any>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expressCustomSetupProperties = mapped
    }

    /**
     * @param values Custom setup without script properties for a SSIS integration runtime.
     */
    @JvmName("ayopocphtpjxhynx")
    public suspend fun expressCustomSetupProperties(vararg values: Any) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expressCustomSetupProperties = mapped
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("ygipjeytkvqxtejd")
    public suspend fun licenseType(`value`: Either<String, IntegrationRuntimeLicenseType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("udnuijdorywlinag")
    public fun licenseType(`value`: String) {
        val toBeMapped = Either.ofLeft<String, IntegrationRuntimeLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value License type for bringing your own license scenario.
     */
    @JvmName("pndgdfifkcplqmif")
    public fun licenseType(`value`: IntegrationRuntimeLicenseType) {
        val toBeMapped = Either.ofRight<String, IntegrationRuntimeLicenseType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.licenseType = mapped
    }

    /**
     * @param value Package stores for the SSIS Integration Runtime.
     */
    @JvmName("kuxduawsjtionyxd")
    public suspend fun packageStores(`value`: List<PackageStoreArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.packageStores = mapped
    }

    /**
     * @param argument Package stores for the SSIS Integration Runtime.
     */
    @JvmName("fqrfdoyssflhjpgq")
    public suspend fun packageStores(argument: List<suspend PackageStoreArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            PackageStoreArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.packageStores = mapped
    }

    /**
     * @param argument Package stores for the SSIS Integration Runtime.
     */
    @JvmName("evehhsmqjvykxorg")
    public suspend fun packageStores(vararg argument: suspend PackageStoreArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            PackageStoreArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.packageStores = mapped
    }

    /**
     * @param argument Package stores for the SSIS Integration Runtime.
     */
    @JvmName("yjfeuvkwmsfgvroj")
    public suspend fun packageStores(argument: suspend PackageStoreArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(PackageStoreArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.packageStores = mapped
    }

    /**
     * @param values Package stores for the SSIS Integration Runtime.
     */
    @JvmName("amlhuqanbeiwbbtk")
    public suspend fun packageStores(vararg values: PackageStoreArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.packageStores = mapped
    }

    internal fun build(): IntegrationRuntimeSsisPropertiesArgs = IntegrationRuntimeSsisPropertiesArgs(
        catalogInfo = catalogInfo,
        credential = credential,
        customSetupScriptProperties = customSetupScriptProperties,
        dataProxyProperties = dataProxyProperties,
        edition = edition,
        expressCustomSetupProperties = expressCustomSetupProperties,
        licenseType = licenseType,
        packageStores = packageStores,
    )
}
