@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.JsonWriteSettingsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Any
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Json write settings.
 * @property filePattern File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is 'setOfObjects'. It is case-sensitive.
 * @property type The write setting type.
 * Expected value is 'JsonWriteSettings'.
 */
public data class JsonWriteSettingsArgs(
    public val filePattern: Output<Any>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.JsonWriteSettingsArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.JsonWriteSettingsArgs =
        com.pulumi.azurenative.datafactory.inputs.JsonWriteSettingsArgs.builder()
            .filePattern(filePattern?.applyValue({ args0 -> args0 }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [JsonWriteSettingsArgs].
 */
@PulumiTagMarker
public class JsonWriteSettingsArgsBuilder internal constructor() {
    private var filePattern: Output<Any>? = null

    private var type: Output<String>? = null

    /**
     * @param value File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is 'setOfObjects'. It is case-sensitive.
     */
    @JvmName("ljeowlqtwvxygiwx")
    public suspend fun filePattern(`value`: Output<Any>) {
        this.filePattern = value
    }

    /**
     * @param value The write setting type.
     * Expected value is 'JsonWriteSettings'.
     */
    @JvmName("vrxuovkrathexkeq")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value File pattern of JSON. This setting controls the way a collection of JSON objects will be treated. The default value is 'setOfObjects'. It is case-sensitive.
     */
    @JvmName("escekqfhitxsylsa")
    public suspend fun filePattern(`value`: Any?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filePattern = mapped
    }

    /**
     * @param value The write setting type.
     * Expected value is 'JsonWriteSettings'.
     */
    @JvmName("ckiynpfrfbtuskha")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): JsonWriteSettingsArgs = JsonWriteSettingsArgs(
        filePattern = filePattern,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
