@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.ManagedIntegrationRuntimeArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Managed integration runtime, including managed elastic and managed dedicated integration runtimes.
 * @property computeProperties The compute resource for managed integration runtime.
 * @property customerVirtualNetwork The name of virtual network to which Azure-SSIS integration runtime will join
 * @property description Integration runtime description.
 * @property managedVirtualNetwork Managed Virtual Network reference.
 * @property ssisProperties SSIS properties for managed integration runtime.
 * @property type The type of integration runtime.
 * Expected value is 'Managed'.
 */
public data class ManagedIntegrationRuntimeArgs(
    public val computeProperties: Output<IntegrationRuntimeComputePropertiesArgs>? = null,
    public val customerVirtualNetwork: Output<IntegrationRuntimeCustomerVirtualNetworkArgs>? = null,
    public val description: Output<String>? = null,
    public val managedVirtualNetwork: Output<ManagedVirtualNetworkReferenceArgs>? = null,
    public val ssisProperties: Output<IntegrationRuntimeSsisPropertiesArgs>? = null,
    public val type: Output<String>,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.ManagedIntegrationRuntimeArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.ManagedIntegrationRuntimeArgs =
        com.pulumi.azurenative.datafactory.inputs.ManagedIntegrationRuntimeArgs.builder()
            .computeProperties(computeProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .customerVirtualNetwork(
                customerVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .managedVirtualNetwork(
                managedVirtualNetwork?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .ssisProperties(ssisProperties?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .type(type.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ManagedIntegrationRuntimeArgs].
 */
@PulumiTagMarker
public class ManagedIntegrationRuntimeArgsBuilder internal constructor() {
    private var computeProperties: Output<IntegrationRuntimeComputePropertiesArgs>? = null

    private var customerVirtualNetwork: Output<IntegrationRuntimeCustomerVirtualNetworkArgs>? = null

    private var description: Output<String>? = null

    private var managedVirtualNetwork: Output<ManagedVirtualNetworkReferenceArgs>? = null

    private var ssisProperties: Output<IntegrationRuntimeSsisPropertiesArgs>? = null

    private var type: Output<String>? = null

    /**
     * @param value The compute resource for managed integration runtime.
     */
    @JvmName("mnlohdunkxtxgmfd")
    public suspend fun computeProperties(`value`: Output<IntegrationRuntimeComputePropertiesArgs>) {
        this.computeProperties = value
    }

    /**
     * @param value The name of virtual network to which Azure-SSIS integration runtime will join
     */
    @JvmName("udfgnlnbiekyiwua")
    public suspend
    fun customerVirtualNetwork(`value`: Output<IntegrationRuntimeCustomerVirtualNetworkArgs>) {
        this.customerVirtualNetwork = value
    }

    /**
     * @param value Integration runtime description.
     */
    @JvmName("qeeductlnvlfwtui")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Managed Virtual Network reference.
     */
    @JvmName("pvpracovckfcguxh")
    public suspend fun managedVirtualNetwork(`value`: Output<ManagedVirtualNetworkReferenceArgs>) {
        this.managedVirtualNetwork = value
    }

    /**
     * @param value SSIS properties for managed integration runtime.
     */
    @JvmName("xoytnsqrbbhtcxee")
    public suspend fun ssisProperties(`value`: Output<IntegrationRuntimeSsisPropertiesArgs>) {
        this.ssisProperties = value
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'Managed'.
     */
    @JvmName("cidyhbuyyexevduk")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value The compute resource for managed integration runtime.
     */
    @JvmName("jaeshrqmmnikgihv")
    public suspend fun computeProperties(`value`: IntegrationRuntimeComputePropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.computeProperties = mapped
    }

    /**
     * @param argument The compute resource for managed integration runtime.
     */
    @JvmName("yudtbhutjeiiacrq")
    public suspend
    fun computeProperties(argument: suspend IntegrationRuntimeComputePropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeComputePropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.computeProperties = mapped
    }

    /**
     * @param value The name of virtual network to which Azure-SSIS integration runtime will join
     */
    @JvmName("qdatykoxxnpmcmpf")
    public suspend
    fun customerVirtualNetwork(`value`: IntegrationRuntimeCustomerVirtualNetworkArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.customerVirtualNetwork = mapped
    }

    /**
     * @param argument The name of virtual network to which Azure-SSIS integration runtime will join
     */
    @JvmName("jrqaxhowcskgpbro")
    public suspend
    fun customerVirtualNetwork(argument: suspend IntegrationRuntimeCustomerVirtualNetworkArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeCustomerVirtualNetworkArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.customerVirtualNetwork = mapped
    }

    /**
     * @param value Integration runtime description.
     */
    @JvmName("siibsiutkfevmiqy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Managed Virtual Network reference.
     */
    @JvmName("kjxsgjlxprdlcthb")
    public suspend fun managedVirtualNetwork(`value`: ManagedVirtualNetworkReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.managedVirtualNetwork = mapped
    }

    /**
     * @param argument Managed Virtual Network reference.
     */
    @JvmName("unrqeohrtekbjrur")
    public suspend
    fun managedVirtualNetwork(argument: suspend ManagedVirtualNetworkReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = ManagedVirtualNetworkReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.managedVirtualNetwork = mapped
    }

    /**
     * @param value SSIS properties for managed integration runtime.
     */
    @JvmName("dpfnknqcnfvltwsr")
    public suspend fun ssisProperties(`value`: IntegrationRuntimeSsisPropertiesArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.ssisProperties = mapped
    }

    /**
     * @param argument SSIS properties for managed integration runtime.
     */
    @JvmName("cgdkoasjpvhfrfqm")
    public suspend
    fun ssisProperties(argument: suspend IntegrationRuntimeSsisPropertiesArgsBuilder.() -> Unit) {
        val toBeMapped = IntegrationRuntimeSsisPropertiesArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.ssisProperties = mapped
    }

    /**
     * @param value The type of integration runtime.
     * Expected value is 'Managed'.
     */
    @JvmName("daccuoujxxthlbpk")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): ManagedIntegrationRuntimeArgs = ManagedIntegrationRuntimeArgs(
        computeProperties = computeProperties,
        customerVirtualNetwork = customerVirtualNetwork,
        description = description,
        managedVirtualNetwork = managedVirtualNetwork,
        ssisProperties = ssisProperties,
        type = type ?: throw PulumiNullFieldException("type"),
    )
}
