@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.azurenative.datafactory.kotlin.inputs

import com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingArgs.builder
import com.pulumi.azurenative.datafactory.kotlin.enums.MappingType
import com.pulumi.core.Either
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Source and target column mapping details.
 * @property attributeReference Reference of the source column used in the mapping. It is used for 'Direct' mapping type only.
 * @property attributeReferences List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
 * @property expression Expression used for 'Aggregate' and 'Derived' type mapping.
 * @property functionName Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type mapping.
 * @property name Name of the target column.
 * @property type Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
 */
public data class MapperAttributeMappingArgs(
    public val attributeReference: Output<MapperAttributeReferenceArgs>? = null,
    public val attributeReferences: Output<List<MapperAttributeReferenceArgs>>? = null,
    public val expression: Output<String>? = null,
    public val functionName: Output<String>? = null,
    public val name: Output<String>? = null,
    public val type: Output<Either<String, MappingType>>? = null,
) : ConvertibleToJava<com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingArgs> {
    override fun toJava(): com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingArgs =
        com.pulumi.azurenative.datafactory.inputs.MapperAttributeMappingArgs.builder()
            .attributeReference(
                attributeReference?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .attributeReferences(
                attributeReferences?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 -> args0.toJava() })
                    })
                }),
            )
            .expression(expression?.applyValue({ args0 -> args0 }))
            .functionName(functionName?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .type(
                type?.applyValue({ args0 ->
                    args0.transform({ args0 -> args0 }, { args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [MapperAttributeMappingArgs].
 */
@PulumiTagMarker
public class MapperAttributeMappingArgsBuilder internal constructor() {
    private var attributeReference: Output<MapperAttributeReferenceArgs>? = null

    private var attributeReferences: Output<List<MapperAttributeReferenceArgs>>? = null

    private var expression: Output<String>? = null

    private var functionName: Output<String>? = null

    private var name: Output<String>? = null

    private var type: Output<Either<String, MappingType>>? = null

    /**
     * @param value Reference of the source column used in the mapping. It is used for 'Direct' mapping type only.
     */
    @JvmName("bjhgiibwflccbeqb")
    public suspend fun attributeReference(`value`: Output<MapperAttributeReferenceArgs>) {
        this.attributeReference = value
    }

    /**
     * @param value List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JvmName("gmaombajlxxtgtoh")
    public suspend fun attributeReferences(`value`: Output<List<MapperAttributeReferenceArgs>>) {
        this.attributeReferences = value
    }

    @JvmName("emsbirgrigmtbwda")
    public suspend fun attributeReferences(vararg values: Output<MapperAttributeReferenceArgs>) {
        this.attributeReferences = Output.all(values.asList())
    }

    /**
     * @param values List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JvmName("iqlfmeekkyjpxugx")
    public suspend fun attributeReferences(values: List<Output<MapperAttributeReferenceArgs>>) {
        this.attributeReferences = Output.all(values)
    }

    /**
     * @param value Expression used for 'Aggregate' and 'Derived' type mapping.
     */
    @JvmName("rfdgqctvnksfdnrl")
    public suspend fun expression(`value`: Output<String>) {
        this.expression = value
    }

    /**
     * @param value Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type mapping.
     */
    @JvmName("feaedkijcrwaivmu")
    public suspend fun functionName(`value`: Output<String>) {
        this.functionName = value
    }

    /**
     * @param value Name of the target column.
     */
    @JvmName("ojrxqwktcvtmmbec")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
     */
    @JvmName("ahaauhlciehmydik")
    public suspend fun type(`value`: Output<Either<String, MappingType>>) {
        this.type = value
    }

    /**
     * @param value Reference of the source column used in the mapping. It is used for 'Direct' mapping type only.
     */
    @JvmName("haneeibgtsmsrexq")
    public suspend fun attributeReference(`value`: MapperAttributeReferenceArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeReference = mapped
    }

    /**
     * @param argument Reference of the source column used in the mapping. It is used for 'Direct' mapping type only.
     */
    @JvmName("kajekeufrnfoharw")
    public suspend
    fun attributeReference(argument: suspend MapperAttributeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = MapperAttributeReferenceArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.attributeReference = mapped
    }

    /**
     * @param value List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JvmName("yrsihxbnlgxfalmk")
    public suspend fun attributeReferences(`value`: List<MapperAttributeReferenceArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.attributeReferences = mapped
    }

    /**
     * @param argument List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JvmName("frpvyjrgsxtrcqpk")
    public suspend
    fun attributeReferences(argument: List<suspend MapperAttributeReferenceArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            MapperAttributeReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attributeReferences = mapped
    }

    /**
     * @param argument List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JvmName("hqdhibqdqkjypnjf")
    public suspend fun attributeReferences(
        vararg
        argument: suspend MapperAttributeReferenceArgsBuilder.() -> Unit,
    ) {
        val toBeMapped = argument.toList().map {
            MapperAttributeReferenceArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.attributeReferences = mapped
    }

    /**
     * @param argument List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JvmName("pnmppgvposmpfpvp")
    public suspend
    fun attributeReferences(argument: suspend MapperAttributeReferenceArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            MapperAttributeReferenceArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.attributeReferences = mapped
    }

    /**
     * @param values List of references for source columns. It is used for 'Derived' and 'Aggregate' type mappings only.
     */
    @JvmName("tbxqgacomktimvod")
    public suspend fun attributeReferences(vararg values: MapperAttributeReferenceArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.attributeReferences = mapped
    }

    /**
     * @param value Expression used for 'Aggregate' and 'Derived' type mapping.
     */
    @JvmName("hxewqnwkfespyhid")
    public suspend fun expression(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expression = mapped
    }

    /**
     * @param value Name of the function used for 'Aggregate' and 'Derived' (except 'Advanced') type mapping.
     */
    @JvmName("leenrfdhtytrcsmg")
    public suspend fun functionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.functionName = mapped
    }

    /**
     * @param value Name of the target column.
     */
    @JvmName("ptmcqcqbjymrjciu")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
     */
    @JvmName("mrwkexsyovugoygk")
    public suspend fun type(`value`: Either<String, MappingType>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
     */
    @JvmName("exwnkadgocipfudv")
    public fun type(`value`: String) {
        val toBeMapped = Either.ofLeft<String, MappingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Type of the CDC attribute mapping. Note: 'Advanced' mapping type is also saved as 'Derived'.
     */
    @JvmName("bosfbhrsxxcuhuay")
    public fun type(`value`: MappingType) {
        val toBeMapped = Either.ofRight<String, MappingType>(value)
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    internal fun build(): MapperAttributeMappingArgs = MapperAttributeMappingArgs(
        attributeReference = attributeReference,
        attributeReferences = attributeReferences,
        expression = expression,
        functionName = functionName,
        name = name,
        type = type,
    )
}
